<!DOCTYPE html>
<html xmlns="http://www.w3.org/1999/html" xmlns="http://www.w3.org/1999/html">
<?php echo $header; ?>
<body class="hold-transition skin-blue sidebar-mini sidebar-collapse">
<div class="wrapper">
    <?php echo $page_header; ?>
    <?php echo $column_left; ?>
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <h1><?php echo $lang['heading_title']; ?></h1>
            <div class="row">
                <div class="col-sm-6">
                    <ol class="breadcrumb">
                        <?php foreach($breadcrumbs as $breadcrumb): ?>
                        <li>
                            <a href="<?php echo $breadcrumb['href']; ?>">
                                <i class="<?php echo $breadcrumb['class']; ?>"></i>
                                <?php echo $breadcrumb['text']; ?>
                            </a>
                        </li>
                        <?php endforeach; ?>
                    </ol>
                </div>
                <div class="col-sm-6">
                    <div class="pull-right">
                        <?php if(isset($isEdit) && $isEdit==1): ?>
                        <?php if($is_post == 0): ?>
                        <a class="btn btn-info" href="<?php echo $action_post; ?>">
                            <i class="fa fa-thumbs-up"></i>
                            &nbsp;<?php echo $lang['post']; ?>
                        </a>
                        <?php endif; ?>
                        <button type="button" class="btn btn-info" href="javascript:void(0);" onclick="getDocumentLedger();">
                            <i class="fa fa-balance-scale"></i>
                            &nbsp;<?php echo $lang['ledger']; ?>
                        </button>
                        <a class="btn btn-info" target="_blank" href="<?php echo $action_print; ?>">
                            <i class="fa fa-print"></i>
                            &nbsp;<?php echo $lang['print']; ?>
                        </a>
                        <?php endif; ?>
                        <a class="btn btn-default" href="<?php echo $action_cancel; ?>">
                            <i class="fa fa-undo"></i>
                            &nbsp;<?php echo $lang['cancel']; ?>
                        </a>
                        <button type="button" class="btn btn-primary" href="javascript:void(0);" onclick="$('#form').submit();" <?php echo ($is_post==1?'disabled="true"':''); ?>>
                        <i class="fa fa-floppy-o"></i>
                        &nbsp;<?php echo $lang['save']; ?>
                        </button>
                    </div>
                </div>
            </div>
        </section>
        <!-- Main content -->
        <section class="content">
            <div class="row">
                <div class="col-sm-12">
                    <div class="box">
                        <div class="box-header">
                            <?php if ($error_warning) { ?>
                            <div class="alert alert-danger alert-dismissable">
                                <button class="close" aria-hidden="true" data-dismiss="alert" type="button">x</button>
                                <?php echo $error_warning; ?>
                            </div>
                            <?php } ?>
                            <?php  if ($success) { ?>
                            <div class="alert alert-success alert-dismissable">
                                <button class="close" aria-hidden="true" data-dismiss="alert" type="button">x</button>
                                <?php echo $success; ?>
                            </div>
                            <?php  } ?>
                        </div><!-- /.box-header -->
                        <div class="box-body">
                            <form  action="<?php echo $action; ?>" method="post" enctype="multipart/form-data" id="form">
                                <input type="hidden" value="<?php echo $document_type_id; ?>" name="document_type_id" id="document_type_id" />
                                <input type="hidden" value="<?php echo $sale_return_id; ?>" name="document_id" id="document_id" />
                                <div class="row">
                                    <div class="col-sm-3">
                                        <div class="form-group">
                                            <label><?php echo $lang['document_no']; ?></label>
                                            <input class="form-control" type="text" name="document_identity" readonly="readonly" value="<?php echo $document_identity; ?>" placeholder="Auto" />
                                        </div>
                                    </div>
                                    <div class="col-sm-3">
                                        <div class="form-group">
                                            <label><span class="required">*</span>&nbsp;<?php echo $lang['document_date']; ?></label>
                                            <input class="form-control dtpDate" type="text" name="document_date" value="<?php echo $document_date; ?>" />
                                        </div>
                                    </div>
                                    <div class="col-sm-3">
                                        <div class="form-group">
                                            <label><span class="required">*</span>&nbsp;<?php echo $lang['manual_ref_no']; ?></label>
                                            <input class="form-control" type="text" name="manual_ref_no" value="<?php echo $manual_ref_no; ?>" />
                                        </div>
                                    </div>
                                </div>
                                <div class="row hide">
                                    <div class="col-sm-3">
                                        <div class="form-group">
                                            <label><?php echo $lang['base_currency']; ?></label>
                                            <input type="hidden" id="base_currency_id" name="base_currency_id"  value="<?php echo $base_currency_id; ?>" />
                                            <input type="text" class="form-control" id="base_currency" name="base_currency" readonly="true" value="<?php echo $base_currency; ?>" />
                                        </div>
                                    </div>
                                    <div class="col-sm-3">
                                        <div class="form-group">
                                            <label><?php echo $lang['document_currency']; ?></label>
                                            <select class="form-control" id="document_currency_id" name="document_currency_id">
                                                <option value="">&nbsp;</option>
                                                <?php foreach($currencys as $currency): ?>
                                                <option value="<?php echo $currency['currency_id']; ?>" <?php echo ($document_currency_id == $currency['currency_id']?'selected="selected"':''); ?>><?php echo $currency['name']; ?></option>
                                                <?php endforeach; ?>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-sm-3">
                                        <div class="form-group">
                                            <label><?php echo $lang['conversion_rate']; ?></label>
                                            <input class="form-control fDecimal" id="conversion_rate" type="text" name="conversion_rate" value="<?php echo $conversion_rate; ?>" onchage="calcNetAmount()" />
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-sm-3">
                                        <div class="form-group">
                                            <label><?php echo $lang['partner_type']; ?></label>
                                            <select class="form-control" id="partner_type_id" name="partner_type_id">
                                                <option value="">&nbsp;</option>
                                                <?php foreach($partner_types as $partner_type): ?>
                                                <option value="<?php echo $partner_type['partner_type_id']; ?>" <?php echo ($partner_type_id == $partner_type['partner_type_id']?'selected="true"':''); ?>><?php echo $partner_type['name']; ?></option>
                                                <?php endforeach; ?>
                                            </select>
                                            <label for="partner_type_id" class="error" style="display: none;"></label>
                                        </div>
                                    </div>
                                    <div class="col-sm-3">
                                        <div class="form-group">
                                            <label><?php echo $lang['partner_name']; ?></label>
                                            <select class="form-control" id="partner_id" name="partner_id">
                                                <option value="">&nbsp;</option>
                                                <?php foreach($partners as $partner): ?>
                                                <option value="<?php echo $partner['partner_id']; ?>" <?php echo ($partner_id == $partner['partner_id']?'selected="true"':''); ?>><?php echo $partner['name']; ?></option>
                                                <?php endforeach; ?>
                                            </select>
                                            <label for="partner_id" class="error" style="display: none;"></label>
                                        </div>
                                    </div>
                                    <div class="col-sm-3">
                                        <div class="form-group">
                                            <label><?php echo $lang['ref_document_identity']; ?></label>
                                            <input type="hidden" id="ref_document_type_id" name="ref_document_type_id" value="<?php echo $ref_document_type_id; ?>" />
                                            <select class="form-control" id="ref_document_identity" name="ref_document_identity">
                                                <option value="">&nbsp;</option>
                                            </select>
                                            <label for="ref_document_identity" class="error" style="display: none;"></label>
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-sm-3">
                                        <div class="form-group">
                                            <label><?php echo $lang['warehouse']; ?></label>
                                            <select class="form-control" id="warehouse_id" name="warehouse_id">
                                                <option value="">&nbsp;</option>
                                                <?php foreach($warehouses as $warehouse): ?>
                                                <option value="<?php echo $warehouse['warehouse_id']; ?>" <?php echo ($warehouse_id == $warehouse['warehouse_id']?'selected="true"':''); ?>><?php echo $warehouse['name']; ?></option>
                                                <?php endforeach; ?>
                                            </select>
                                            <label for="warehouse_id" class="error" style="display: none;"></label>
                                        </div>
                                    </div>
                                    <div class="col-sm-6">
                                        <div class="form-group">
                                            <label><?php echo $lang['remarks']; ?></label>
                                            <input class="form-control" type="text" name="remarks" value="<?php echo $remarks; ?>" />
                                        </div>
                                    </div>
                                    <div class="col-sm-3">
                                        <div class="form-group">
                                            <label><?php echo $lang['rate_type']; ?></label>
                                            <input class="form-control" readonly type="text" id="rate_type" name="rate_type" value="<?php echo $rate_type; ?>" />
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-sm-12">
                                        <div class="table-responsive form-group">
                                            <table id="tblSaleReturn" class="table table-striped table-bordered">
                                                <thead>
                                                <tr align="center">
                                                    <td style="width: 15px;">&nbsp;</td>
                                                    <td style="width: 5%;"><?php echo $lang['case_no']; ?></td>
                                                    <td style="width: 5%;"><?php echo $lang['product_code']; ?></td>
                                                    <td style="width: 200px;"><?php echo $lang['product_name']; ?></td>
                                                    <td style="width: 5%;"><?php echo $lang['container_no']; ?></td>
                                                    <td style="width: 5%;"><?php echo $lang['batch_no']; ?></td>
                                                    <td style="width: 5%;"><?php echo $lang['quantity']; ?></td>
                                                    <td style="width: 5%;"><?php echo $lang['total_cubic_meter']; ?></td>
                                                    <td style="width: 5%;"><?php echo $lang['total_cubic_feet']; ?></td>
                                                    <td style="width: 5%;"><?php echo $lang['rate']; ?></td>
                                                    <td style="width: 5%;"><?php echo $lang['amount']; ?></td>
                                                    <td style="width: 5%;"><?php echo $lang['remarks']; ?></td>
                                                    <td style="width: 30px;">&nbsp;</td>
                                                </tr>
                                                </thead>
                                                <tbody >
                                                <?php foreach($sale_return_details as $grid_row => $detail): ?>
                                                <tr id="grid_row_<?php echo $grid_row; ?>" data-row_id="<?php echo $grid_row; ?>">
                                                    <td>
                                                        <a onclick="removeRow(this);" title="Remove" class="btn btn-sm btn-danger" href="javascript:void(0);"><i class="fa fa-times"></i></a>
                                                    </td>
                                                    <td></td>
                                                    <td>
                                                        <input type="text" class="form-control" id="sale_return_detail_product_code_<?php echo $grid_row; ?>" name="sale_return_details[<?php echo $grid_row; ?>][product_code]" value="<?php echo $detail['product_code'];?>" readonly />
                                                    </td>
                                                    <td>
                                                        <input type="hidden" class="form-control" id="sale_return_detail_product_id_<?php echo $grid_row; ?>" name="sale_return_details[<?php echo $grid_row; ?>][product_id]" value="<?php echo $detail['product_id'];?>" readonly />
                                                        <input style="min-width: 400px;" type="text" class="form-control" id="sale_return_detail_product_name_<?php echo $grid_row; ?>" name="sale_return_details[<?php echo $grid_row; ?>][product_name]" value="<?php echo $detail['product_name'];?>" readonly />
                                                    </td>
                                                    <td>
                                                        <input style="min-width: 110px;" type="text" class="form-control" name="sale_return_details[<?php echo $grid_row; ?>][container_no]" id="sale_return_detail_container_no_<?php echo $grid_row; ?>" value="<?php echo $detail['container_no']; ?>" />
                                                    </td>
                                                    <td>
                                                        <input style="min-width: 110px;" type="text" class="form-control" name="sale_return_details[<?php echo $grid_row; ?>][batch_no]" id="sale_return_detail_batch_no_<?php echo $grid_row; ?>" value="<?php echo $detail['batch_no']; ?>" />
                                                    </td>
                                                    <td>
                                                        <input type="hidden" class="form-control" name="sale_return_details[<?php echo $grid_row; ?>][unit_id]" id="sale_return_detail_unit_id_<?php echo $grid_row; ?>" value="<?php echo $detail['unit_id']; ?>" />
                                                        <input onchange="updateCubicFeet(this);" style="min-width: 100px;" type="text" class="form-control fPDecimal" name="sale_return_details[<?php echo $grid_row; ?>][qty]" id="sale_return_detail_qty_<?php echo $grid_row; ?>" value="<?php echo $detail['qty']; ?>" />
                                                    </td>
                                                    <td>
                                                        <input type="hidden" class="form-control" id="sale_return_detail_avg_cubic_meter_<?php echo $grid_row; ?>" value="<?php echo $detail['avg_cubic_meter']; ?>" />
                                                        <input onchange="calculateTotalCubicFeet(this);" style="min-width: 100px;" type="text" class="form-control fPDecimal" name="sale_return_details[<?php echo $grid_row; ?>][total_cubic_meter]" id="sale_return_detail_total_cubic_meter_<?php echo $grid_row; ?>" value="<?php echo $detail['total_cubic_meter']; ?>" />
                                                    </td>
                                                    <td>
                                                        <input type="hidden" class="form-control" id="sale_return_detail_avg_cubic_feet_<?php echo $grid_row; ?>" value="<?php echo $detail['avg_cubic_feet']; ?>" />
                                                        <input onchange="calculateTotalCubicMeter(this);" style="min-width: 100px;" type="text" class="form-control fPDecimal" name="sale_return_details[<?php echo $grid_row; ?>][total_cubic_feet]" id="sale_return_detail_total_cubic_feet_<?php echo $grid_row; ?>" value="<?php echo $detail['total_cubic_feet']; ?>" />
                                                    </td>
                                                    <td>
                                                        <input onchange="calculateAmount(this);" style="min-width: 100px;" type="text" class="form-control fPDecimal" name="sale_return_details[<?php echo $grid_row; ?>][rate]" id="sale_return_detail_rate_<?php echo $grid_row; ?>" value="<?php echo $detail['rate']; ?>" />
                                                        <input type="hidden" class="form-control fPDecimal" name="sale_return_details[<?php echo $grid_row; ?>][cog_rate]" id="sale_return_detail_cog_rate_<?php echo $grid_row; ?>" value="<?php echo $detail['cog_rate']; ?>" />
                                                    </td>
                                                    <td>
                                                        <input type="text" style="min-width: 100px;" class="form-control fPDecimal" name="sale_return_details[<?php echo $grid_row; ?>][amount]" id="sale_return_detail_amount_<?php echo $grid_row; ?>" value="<?php echo $detail['amount']; ?>" readonly="true" />
                                                        <input type="hidden" style="min-width: 100px;" class="form-control fPDecimal" name="sale_return_details[<?php echo $grid_row; ?>][cog_amount]" id="sale_return_detail_cog_amount_<?php echo $grid_row; ?>" value="<?php echo $detail['cog_amount']; ?>" readonly="true" />
                                                    </td>
                                                    <td>
                                                        <input type="text" style="min-width: 100px;" class="form-control" name="sale_return_details[<?php echo $grid_row; ?>][remarks]" id="sale_return_detail_remarks_<?php echo $grid_row; ?>" value="<?php echo $detail['remarks']; ?>" />
                                                    </td>
                                                    <td><a onclick="removeRow(this);" title="Remove" class="btn btn-sm btn-danger" href="javascript:void(0);"><i class="fa fa-times"></i></a></td>
                                                </tr>
                                                <?php endforeach; ?>
                                                <?php $grid_row = count($sale_return_details); ?>
                                                </tbody>
                                                <tfoot>
                                                </tfoot>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-sm-offset-4 col-sm-2">
                                        <div class="form-group">
                                            <label><?php echo $lang['total_quantity']; ?></label>
                                            <input type="text" id="total_quantity" name="total_qty" value="<?php echo $total_qty; ?>" class="form-control fDecimal" readonly="true" />
                                        </div>
                                    </div>
                                    <div class="col-sm-2">
                                        <div class="form-group">
                                            <label><?php echo $lang['total_cubic_meter']; ?></label>
                                            <input class="form-control fDecimal" type="text" id="total_cubic_meter" name="total_cubic_meter" value="<?php echo $total_cubic_meter; ?>" readonly="readonly" />
                                        </div>
                                    </div>
                                    <div class="col-sm-2">
                                        <div class="form-group">
                                            <label><?php echo $lang['total_cubic_feet']; ?></label>
                                            <input class="form-control fDecimal" type="text" id="total_cubic_feet" name="total_cubic_feet" value="<?php echo $total_cubic_feet; ?>" readonly="readonly" />
                                        </div>
                                    </div>
                                    <div class="col-sm-2">
                                        <div class="form-group">
                                            <label><?php echo $lang['total_amount']; ?></label>
                                            <input class="form-control fDecimal" type="text" id="net_amount" name="net_amount" value="<?php echo $net_amount; ?>" readonly="readonly" />
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-sm-offset-6 col-sm-3">
                                        <div class="form-group">
                                            <label><?php echo $lang['cash_returned']; ?></label>
                                            <input type="text" id="cash_returned" name="cash_returned" value="<?php echo $cash_returned; ?>" class="form-control fDecimal" placeholder="0.00" onchange="calculateTotal();" />
                                        </div>
                                    </div>
                                    <div class="col-sm-3">
                                        <div class="form-group">
                                            <label><?php echo $lang['balance_amount']; ?></label>
                                            <input type="text" id="balance_amount" name="balance_amount" value="<?php echo $balance_amount; ?>" class="form-control fDecimal"  readonly="readonly" />
                                        </div>
                                    </div>
                                </div>
                            </form>
                        </div>
                        <div class="box-footer">
                            <div class="pull-right">
                                <?php if(isset($isEdit) && $isEdit==1): ?>
                                <?php if($is_post == 0): ?>
                                <a class="btn btn-info" href="<?php echo $action_post; ?>">
                                    <i class="fa fa-thumbs-up"></i>
                                    &nbsp;<?php echo $lang['post']; ?>
                                </a>
                                <?php endif; ?>
                                <button type="button" class="btn btn-info" href="javascript:void(0);" onclick="getDocumentLedger();">
                                    <i class="fa fa-balance-scale"></i>
                                    &nbsp;<?php echo $lang['ledger']; ?>
                                </button>
                                <a class="btn btn-info" target="_blank" href="<?php echo $action_print; ?>">
                                    <i class="fa fa-print"></i>
                                    &nbsp;<?php echo $lang['print']; ?>
                                </a>
                                <?php endif; ?>
                                <a class="btn btn-default" href="<?php echo $action_cancel; ?>">
                                    <i class="fa fa-undo"></i>
                                    &nbsp;<?php echo $lang['cancel']; ?>
                                </a>
                                <button type="button" class="btn btn-primary" href="javascript:void(0);" onclick="$('#form').submit();" <?php echo ($is_post==1?'disabled="true"':''); ?>>
                                <i class="fa fa-floppy-o"></i>
                                &nbsp;<?php echo $lang['save']; ?>
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
    <link rel="stylesheet" href="plugins/dataTables/dataTables.bootstrap.css">
    <script src="plugins/dataTables/jquery.dataTables.js"></script>
    <script src="plugins/dataTables/dataTables.bootstrap.js"></script>
    <script type="text/javascript" src="../admin/view/js/inventory/sale_return.js"></script>
    <script type="text/javascript" src="plugins/validate/jquery.validate.min.js"></script>
    <script>
        jQuery('#form').validate(<?php echo $strValidation; ?>);
        var $lang = <?php echo json_encode($lang) ?>;
        var $partner_id = '<?php echo $partner_id; ?>';
        var $grid_row = '<?php echo $grid_row; ?>';
        var $ref_document_type_id = '<?php echo $ref_document_type_id; ?>';
        var $ref_document_identity = '<?php echo $ref_document_identity; ?>';
        var $UrlGetRefDocumentNo = '<?php echo $href_get_ref_document_no; ?>';
        var $UrlGetRefDocument = '<?php echo $href_get_ref_document; ?>';
        var $products = <?php echo json_encode($products) ?>;
        var $warehouses = <?php echo json_encode($warehouses) ?>;
        function formatRepo (repo) {
            if (repo.loading) return repo.text;

            var markup = "<div class='select2-result-repository clearfix'>";
            if(repo.image_url) {
                markup +="<div class='select2-result-repository__avatar'><img src='" + repo.image_url + "' /></div>";
            }
            markup +="<div class='select2-result-repository__meta'>";
            markup +="  <div class='select2-result-repository__title'>" + repo.name + "</div>";

            if (repo.description) {
                markup += "<div class='select2-result-repository__description'>" + repo.description + "</div>";
            }

            markup += "<div class='select2-result-repository__statistics'>" +
                "   <div class='help-block'>" + repo.length + " X " + repo.width + " X " + repo.thickness + "</div>" +
                "</div>" +
                "</div></div>";

            return markup;
        }

        function formatRepoSelection (repo) {
            return repo.name || repo.text;
        }
    </script>
    <?php echo $page_footer; ?>
    <?php echo $column_right; ?>
</div><!-- ./wrapper -->
<?php echo $footer; ?>
</body>
</html>