<!DOCTYPE html>
<html xmlns="http://www.w3.org/1999/html" xmlns="http://www.w3.org/1999/html">
<?php echo $header; ?>
<body class="hold-transition skin-blue sidebar-mini sidebar-collapse">
<div class="wrapper">
    <?php echo $page_header; ?>
    <?php echo $column_left; ?>
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <h1><?php echo $lang['heading_title']; ?></h1>
            <div class="row">
                <div class="col-sm-6">
                    <ol class="breadcrumb">
                        <?php foreach($breadcrumbs as $breadcrumb): ?>
                        <li>
                            <a href="<?php echo $breadcrumb['href']; ?>">
                                <i class="<?php echo $breadcrumb['class']; ?>"></i>
                                <?php echo $breadcrumb['text']; ?>
                            </a>
                        </li>
                        <?php endforeach; ?>
                    </ol>
                </div>
                <div class="col-sm-6">
                    <div class="pull-right">
                        <?php if(isset($isEdit) && $isEdit==1): ?>
                        <?php if($is_post == 0): ?>
                        <a class="btn btn-info" href="<?php echo $action_post; ?>">
                            <i class="fa fa-thumbs-up"></i>
                            &nbsp;<?php echo $lang['post']; ?>
                        </a>
                        <?php endif; ?>
                        <button type="button" class="btn btn-info" href="javascript:void(0);" onclick="getDocumentLedger();">
                            <i class="fa fa-balance-scale"></i>
                            &nbsp;<?php echo $lang['ledger']; ?>
                        </button>
                        <a class="btn btn-info" target="_blank" href="<?php echo $action_print; ?>">
                            <i class="fa fa-print"></i>
                            &nbsp;<?php echo $lang['print']; ?>
                        </a>
                        <?php endif; ?>
                        <a class="btn btn-default" href="<?php echo $action_cancel; ?>">
                            <i class="fa fa-undo"></i>
                            &nbsp;<?php echo $lang['cancel']; ?>
                        </a>
                        <button type="button" class="btn btn-primary" href="javascript:void(0);" onclick="$('#form').submit();" <?php echo ($is_post==1?'disabled="true"':''); ?>>
                        <i class="fa fa-floppy-o"></i>
                        &nbsp;<?php echo $lang['save']; ?>
                        </button>
                    </div>
                </div>
            </div>
        </section>
        <!-- Main content -->
        <section class="content">
            <div class="row">
                <div class="col-sm-12">
                    <div class="box">
                        <div class="box-header">
                            <?php if ($error_warning) { ?>
                            <div class="alert alert-danger alert-dismissable">
                                <button class="close" aria-hidden="true" data-dismiss="alert" type="button">x</button>
                                <?php echo $error_warning; ?>
                            </div>
                            <?php } ?>
                            <?php  if ($success) { ?>
                            <div class="alert alert-success alert-dismissable">
                                <button class="close" aria-hidden="true" data-dismiss="alert" type="button">x</button>
                                <?php echo $success; ?>
                            </div>
                            <?php  } ?>
                        </div><!-- /.box-header -->
                        <div class="box-body">
                            <form  action="<?php echo $action; ?>" method="post" enctype="multipart/form-data" id="form">
                                <input type="hidden" value="<?php echo $document_type_id; ?>" id="document_type_id" />
                                <input type="hidden" value="<?php echo $purchase_invoice_id; ?>" id="document_id" />
                                <div class="row">
                                    <div class="col-sm-3">
                                        <div class="form-group">
                                            <label><?php echo $lang['invoice_type']; ?></label>
                                            <div class="row">
                                                <div class="col-sm-3 col-xs-6">
                                                    <div class="radio">
                                                        <label>
                                                            <input name="invoice_type" id="invoice_type_credit" value="Credit" <?php echo ($invoice_type != 'Cash'?'checked':''); ?> type="radio">
                                                            Credit
                                                        </label>
                                                    </div>
                                                </div>
                                                <div class="col-sm-3 col-xs-6">
                                                    <div class="radio">
                                                        <label>
                                                            <input name="invoice_type" id="invoice_type_cash" value="Cash" <?php echo ($invoice_type == 'Cash'?'checked':''); ?> type="radio">
                                                            Cash
                                                        </label>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-sm-3">
                                        <div class="form-group">
                                            <label><?php echo $lang['document_no']; ?></label>
                                            <input class="form-control" type="text" name="document_identity" readonly="readonly" value="<?php echo $document_identity; ?>" placeholder="Auto" />
                                        </div>
                                    </div>
                                    <div class="col-sm-3">
                                        <div class="form-group">
                                            <label><span class="required">*</span>&nbsp;<?php echo $lang['document_date']; ?></label>
                                            <input class="form-control dtpDate" type="text" name="document_date" value="<?php echo $document_date; ?>" />
                                        </div>
                                    </div>
                                    <div class="col-sm-3">
                                        <div class="form-group">
                                            <label><span class="required">*</span>&nbsp;<?php echo $lang['manual_ref_no']; ?></label>
                                            <input class="form-control" type="text" name="manual_ref_no" value="<?php echo $manual_ref_no; ?>" />
                                        </div>
                                    </div>
                                </div>
                                <div class="row hide">
                                    <div class="col-sm-3">
                                        <div class="form-group">
                                            <label><?php echo $lang['base_currency']; ?></label>
                                            <input type="hidden" id="base_currency_id" name="base_currency_id"  value="<?php echo $base_currency_id; ?>" />
                                            <input type="text" class="form-control" id="base_currency" name="base_currency" readonly="true" value="<?php echo $base_currency; ?>" />
                                        </div>
                                    </div>
                                    <div class="col-sm-3">
                                        <div class="form-group">
                                            <label><?php echo $lang['document_currency']; ?></label>
                                            <select class="form-control" id="document_currency_id" name="document_currency_id">
                                                <option value="">&nbsp;</option>
                                                <?php foreach($currencys as $currency): ?>
                                                <option value="<?php echo $currency['currency_id']; ?>" <?php echo ($document_currency_id == $currency['currency_id']?'selected="selected"':''); ?>><?php echo $currency['name']; ?></option>
                                                <?php endforeach; ?>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-sm-3">
                                        <div class="form-group">
                                            <label><?php echo $lang['conversion_rate']; ?></label>
                                            <input class="form-control fDecimal" id="conversion_rate" type="text" name="conversion_rate" value="<?php echo $conversion_rate; ?>" onchage="calcNetAmount()" />
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-sm-3">
                                        <div class="form-group">
                                            <label><?php echo $lang['partner_type']; ?></label>
                                            <select class="form-control" id="partner_type_id" name="partner_type_id">
                                                <option value="">&nbsp;</option>
                                                <?php foreach($partner_types as $partner_type): ?>
                                                <option value="<?php echo $partner_type['partner_type_id']; ?>" <?php echo ($partner_type_id == $partner_type['partner_type_id']?'selected="true"':''); ?>><?php echo $partner_type['name']; ?></option>
                                                <?php endforeach; ?>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-sm-3">
                                        <div class="form-group">
                                            <label><?php echo $lang['partner_name']; ?></label>
                                            <select class="form-control" id="partner_id" name="partner_id">
                                                <option value="">&nbsp;</option>
                                            </select>
                                            <label for="partner_id" class="error" style="display: none;"></label>
                                        </div>
                                    </div>

                                    <div class="col-sm-3 hide">
                                        <div class="form-group">
                                            <label><?php echo $lang['ref_document_type']; ?></label>
                                            <select class="form-control" id="ref_document_type_id">
                                                <option value="">&nbsp;</option>
                                                <!-- <option value="4"><?php echo $lang['purchase_order']; ?></option> -->
                                                <option value="17"><?php echo $lang['goods_received']; ?></option>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-sm-3 hide">
                                        <div class="form-group">
                                            <label><?php echo $lang['ref_document_no']; ?></label>
                                            <div class="input-group">
                                                <select class="form-control" id="ref_document_identity">
                                                    <option value="">&nbsp;</option>
                                                </select>
                                                <span class="input-group-btn">
                                                        <button id="addRefDocument" type="button" class="btn btn-info btn-flat"><i class="fa fa-plus"></i></button>
                                                    </span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-sm-6">
                                        <div class="form-group">
                                            <label><?php echo $lang['remarks']; ?></label>
                                            <input class="form-control" type="text" name="remarks" value="<?php echo $remarks; ?>" />
                                        </div>
                                    </div>
                                    <div class="col-sm-3">
                                        <div class="form-group">
                                            <label><?php echo $lang['rate_type']; ?></label>
                                            <div class="row">
                                                <div class="col-sm-3 col-xs-4">
                                                    <div class="radio">
                                                        <label>
                                                            <input name="rate_type" id="rate_type_pcs" value="PCS" <?php echo ($rate_type == 'PCS'?'checked':''); ?> type="radio">
                                                            Pieces
                                                        </label>
                                                    </div>
                                                </div>
                                                <div class="col-sm-3 col-xs-4">
                                                    <div class="radio" hidden="hidden">
                                                        <label>
                                                            <input name="rate_type" id="rate_type_cbf" value="CBF" <?php echo ($rate_type == 'CBF'?'checked':''); ?> type="radio">
                                                            CBF
                                                        </label>
                                                    </div>
                                                </div>
                                                <div class="col-sm-3 col-xs-4">
                                                    <div class="radio" hidden="hidden">
                                                        <label>
                                                            <input name="rate_type" id="rate_type_log" value="LOG" <?php echo ($rate_type == 'LOG'?'checked':''); ?> type="radio">
                                                            LOG
                                                        </label>
                                                    </div>
                                                </div>
                                            </div>
                                            <label for="rate_type" class="error" style="display: none;">&nbsp;</label>
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-sm-12">
                                        <div class="table-responsive form-group">
                                            <table id="tblPurchaseInvoice" class="table table-striped table-bordered" style="width: 2000px !important;max-width: 2000px !important;">
                                                <thead>
                                                <tr align="center" data-row_id="H">
                                                    <td style="width: 6%;"><a class="btnAddGrid btn btn-xs btn-primary" title="Add" href="javascript:void(0);"><i class="fa fa-plus"></i></a></td>
                                                    <td style="width: 5%;"><?php echo $lang['document']; ?></td>
                                                    <td style="width: 5%;"><?php echo $lang['warehouse']; ?></td>
                                                    <td style="width: 5%;"><?php echo $lang['product_code']; ?></td>
                                                    <td style="width: 5%;"><?php echo $lang['product_name']; ?></td>
                                                    <td style="width: 5%;"><?php echo $lang['container_no']; ?></td>
                                                    <td style="width: 5%;"><?php echo $lang['batch_no']; ?></td>
                                                    <td style="width: 5%;"><?php echo $lang['quantity']; ?></td>
                                                    <td style="width: 5%;"><?php echo $lang['total_cubic_meter']; ?></td>
                                                    <td style="width: 5%;"><?php echo $lang['total_cubic_feet']; ?></td>
                                                    <td style="width: 5%;"><?php echo $lang['rate']; ?></td>
                                                    <td style="width: 5%;"><?php echo $lang['amount']; ?></td>
                                                    <td style="width: 5%";><?php echo $lang['remarks']; ?></td>
                                                    <td style="width: 6%;"><a class="btnAddGrid btn btn-xs btn-primary" title="Add" href="javascript:void(0);"><i class="fa fa-plus"></i></a></td>
                                                </tr>
                                                </thead>
                                                <tbody >
                                                <?php foreach($purchase_invoice_details as $grid_row => $detail): ?>
                                                <tr id="grid_row_<?php echo $grid_row; ?>" data-row_id="<?php echo $grid_row; ?>">
                                                    <td style="min-width: 40px !important;">
                                                        <a onclick="removeRow(this);" title="Remove" class="btn btn-xs btn-danger" href="javascript:void(0);"><i class="fa fa-times"></i></a>
                                                        <a title="Duplicate" class="btn btn-xs btn-primary btnAddDuplicate" href="javascript:void(0);"><i class="fa fa-clone"></i></a>
                                                        <a title="Add" class="btn btn-xs btn-primary btnAddGrid" href="javascript:void(0);"><i class="fa fa-plus"></i></a>
                                                    </td>
                                                    <td>
                                                        <input type="hidden" name="purchase_invoice_details[<?php echo $grid_row; ?>][ref_document_type_id]" id="purchase_invoice_detail_ref_document_type_id_<?php echo $grid_row; ?>" value="<?php echo $detail['ref_document_type_id']; ?>" />
                                                        <input type="hidden" name="purchase_invoice_details[<?php echo $grid_row; ?>][ref_document_identity]" id="purchase_invoice_detail_ref_document_identity_<?php echo $grid_row; ?>" value="<?php echo $detail['ref_document_identity']; ?>" />
                                                        <a target="_blank" href="<?php echo $detail['href']; ?>"><?php echo $detail['ref_document_identity']; ?></a>
                                                    </td>
                                                    <td>
                                                        <select class="form-control select2" id="purchase_invoice_detail_warehouse_id_<?php echo $grid_row; ?>" name="purchase_invoice_details[<?php echo $grid_row; ?>][warehouse_id]" >
                                                            <option value="">&nbsp;</option>
                                                            <?php foreach($warehouses as $warehouse): ?>
                                                            <?php if($warehouse['warehouse_id']==$detail['warehouse_id']): ?>
                                                            <option value="<?php echo $warehouse['warehouse_id']; ?>" selected="true"><?php echo $warehouse['name']; ?></option>
                                                            <?php else: ?>
                                                            <option value="<?php echo $warehouse['warehouse_id']; ?>"><?php echo $warehouse['name']; ?></option>
                                                            <?php endif; ?>
                                                            <?php endforeach; ?>
                                                        </select>
                                                    </td>
                                                    <td>
                                                        <input onchange="getProductByCode(this);" type="text" style="min-width: 100px;" class="form-control" name="purchase_invoice_details[<?php echo $grid_row; ?>][product_code]" id="purchase_invoice_detail_product_code_<?php echo $grid_row; ?>" value="<?php echo $detail['product_code']; ?>" />
                                                    </td>
                                                    <td>
                                                        <div class="input-group">
                                                            <select onchange="getProductById(this);" class="form-control select2 product" id="purchase_invoice_detail_product_id_<?php echo $grid_row; ?>" name="purchase_invoice_details[<?php echo $grid_row; ?>][product_id]" >
                                                                <option value="<?php echo $detail['product_id']; ?>" selected="selected"><?php echo $detail['product_name']; ?></option>
                                                            </select>
                                                            <span class="input-group-btn ">
                                                                <button class="btn btn-default btn-flat QSearchProduct" id="QSearchProduct" type="button" data-element="purchase_invoice_detail_product_id_<?php echo $grid_row; ?>" data-field="product_id">
                                                                    <i class="fa fa-search"></i>
                                                                </button>
                                                            </span>
                                                        </div>
                                                    </td>
                                                    <!--       <td>
                                                               <input style="min-width: 100px;" type="text" class="form-control fPDecimal" id="purchase_invoice_detail_cubic_meter_<?php echo $grid_row; ?>" name="purchase_invoice_details[<?php echo $grid_row; ?>][cubic_meter]" value="<?php echo $detail['cubic_meter']; ?>" readonly />
                                                           </td>
                                                           <td>
                                                               <input style="min-width: 100px;" type="text" class="form-control fPDecimal" id="purchase_invoice_detail_cubic_feet_<?php echo $grid_row; ?>" name="purchase_invoice_details[<?php echo $grid_row; ?>][cubic_feet]" value="<?php echo $detail['cubic_feet']; ?>" readonly />
                                                           </td> -->
                                                    <td>
                                                        <input style="min-width: 100px;" type="text" class="form-control" name="purchase_invoice_details[<?php echo $grid_row; ?>][container_no]" id="purchase_invoice_detail_container_no_<?php echo $grid_row; ?>" value="<?php echo $detail['container_no']; ?>" />
                                                    </td>
                                                    <td>
                                                        <input style="min-width: 100px;" type="text" class="form-control" name="purchase_invoice_details[<?php echo $grid_row; ?>][batch_no]" id="purchase_invoice_detail_batch_no_<?php echo $grid_row; ?>" value="<?php echo $detail['batch_no']; ?>" />
                                                    </td>
                                                    <td>
                                                        <input type="hidden" class="form-control" id="purchase_invoice_detail_unit_id_<?php echo $grid_row; ?>" value="<?php echo $detail['unit_id']; ?>" />
                                                        <input onchange="updateCubicFeet(this);" style="min-width: 100px;" type="text" class="form-control fPDecimal" name="purchase_invoice_details[<?php echo $grid_row; ?>][qty]" id="purchase_invoice_detail_qty_<?php echo $grid_row; ?>" value="<?php echo $detail['qty']; ?>" />
                                                    </td>
                                                    <td>
                                                        <input onchange="calculateTotalCubicFeet(this);" style="min-width: 100px;" type="text" class="form-control fPDecimal" id="purchase_invoice_detail_total_cubic_meter_<?php echo $grid_row; ?>" name="purchase_invoice_details[<?php echo $grid_row; ?>][total_cubic_meter]" value="<?php echo $detail['total_cubic_meter']; ?>" readonly />
                                                    </td>
                                                    <td>
                                                        <input onchange="calculateTotalCubicMeter(this);" style="min-width: 100px;" type="text" class="form-control fPDecimal" id="purchase_invoice_detail_total_cubic_feet_<?php echo $grid_row; ?>" value="<?php echo $detail['total_cubic_feet']; ?>" name="purchase_invoice_details[<?php echo $grid_row; ?>][total_cubic_feet]" readonly />
                                                    </td>
                                                    <td>
                                                        <input onchange="calculateAmount(this);" style="min-width: 100px;" type="text" class="form-control fPDecimal" name="purchase_invoice_details[<?php echo $grid_row; ?>][rate]" id="purchase_invoice_detail_rate_<?php echo $grid_row; ?>" value="<?php echo $detail['rate']; ?>" readonly />
                                                    </td>
                                                    <td>
                                                        <input type="text" style="min-width: 100px;" class="form-control fPDecimal" id="purchase_invoice_detail_amount_<?php echo $grid_row; ?>" name="purchase_invoice_details[<?php echo $grid_row; ?>][amount]" value="<?php echo $detail['amount']; ?>"  readonly="true" />
                                                    </td>
                                                    <td>
                                                        <input type="text" style="min-width: 100px;" class="form-control" name="purchase_invoice_details[<?php echo $grid_row; ?>][remarks]" id="purchase_invoice_detail_remarks_<?php echo $grid_row; ?>" value="<?php echo $detail['remarks']; ?>" />
                                                    </td>
                                                    <td style="min-width: 90px !important;">
                                                        <a onclick="removeRow(this);" title="Remove" class="btn btn-xs btn-danger" href="javascript:void(0);"><i class="fa fa-times"></i></a>
                                                        &nbsp;<a title="Duplicate" class="btn btn-xs btn-primary btnAddDuplicate" href="javascript:void(0);"><i class="fa fa-clone"></i></a>
                                                        &nbsp;<a title="Add" class="btn btn-xs btn-primary btnAddGrid" href="javascript:void(0);"><i class="fa fa-plus"></i></a>
                                                    </td>
                                                </tr>
                                                <?php endforeach; ?>
                                                <?php $grid_row = count($purchase_invoice_details); ?>
                                                </tbody>
                                                <tfoot>
                                                </tfoot>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-sm-3">
                                        <div class="form-group">
                                            <label><?php echo $lang['total_cubic_meter']; ?></label>
                                            <input class="form-control fDecimal" type="text" id="total_cubic_meter" name="total_cubic_meter" value="<?php echo $total_cubic_meter; ?>" readonly/>
                                        </div>
                                    </div>
                                    <div class="col-sm-3">
                                        <div class="form-group">
                                            <label><?php echo $lang['total_cubic_feet']; ?></label>
                                            <input class="form-control fDecimal" type="text" id="total_cubic_feet" name="total_cubic_feet" value="<?php echo $total_cubic_feet; ?>" readonly/>
                                        </div>
                                    </div>
                                    <div class="col-sm-3">
                                        <div class="form-group">
                                            <label><?php echo $lang['total_quantity']; ?></label>
                                            <input type="text" id="total_quantity" name="total_quantity" value="<?php echo $total_quantity; ?>" class="form-control fDecimal" readonly="true" />
                                        </div>
                                    </div>
                                    <div class="col-sm-3">
                                        <div class="form-group">
                                            <label><?php echo $lang['total_amount']; ?></label>
                                            <input type="text" id="item_amount" name="item_amount" value="<?php echo $item_amount; ?>" class="form-control fDecimal" readonly="true" />
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-sm-7">
                                        <div class="table-responsive">
                                            <table id="tblLedger" class="table table-bordered">
                                                <thead>
                                                <tr>
                                                    <th style="min-width: 5px; max-width: :5px; !important;">
                                                        <a class="btnAddLedger btn btn-xs btn-primary" title="Add" href="javascript:void(0);"><i class="fa fa-plus"></i></a>
                                                    </th>
                                                    <th class="text-center"><?php echo $lang['ledger_head']; ?></th>
                                                    <th class="text-center"><?php echo $lang['debit']; ?></th>
                                                    <th class="text-center"><?php echo $lang['credit']; ?></th>
                                                </tr>
                                                </thead>
                                                <tbody>
                                                <?php $ledger_row=0; ?>
                                                <?php foreach($purchase_invoice_ledgers as $ledger): ?>
                                                <tr id="ledger_row_<?php echo $ledger_row; ?>" data-ledger_row="<?php echo $ledger_row; ?>">
                                                    <td>
                                                        <a onclick="removeLedgerRow(this);" title="Remove" class="btn btn-xs btn-danger" href="javascript:void(0);"><i class="fa fa-times"></i></a>
                                                    </td>
                                                    <td>
                                                        <select class="form-control" id="purchase_invoice_ledger_<?php echo $ledger_row; ?>_coa_id" name="purchase_invoice_ledgers[<?php echo $ledger_row; ?>][coa_id]">
                                                            <option value="">&nbsp;</option>
                                                            <?php foreach($coas as $coa): ?>
                                                            <option value="<?php echo $coa['coa_level3_id']; ?>" <?php echo ($coa['coa_level3_id']==$ledger['coa_id']?'selected':'');?>><?php echo $coa['level3_display_name']; ?></option>
                                                            <?php endforeach; ?>
                                                        </select>
                                                    </td>
                                                    <td>
                                                        <input onchange="calculateLedger(this);" type="text" class="form-control fPDecimal text-right" id="purchase_invoice_ledger_<?php echo $ledger_row; ?>_debit" name="purchase_invoice_ledgers[<?php echo $ledger_row; ?>][debit]" value="<?php echo $ledger['debit']; ?>" />
                                                    </td>
                                                    <td>
                                                        <input onchange="calculateLedger(this);" type="text" class="form-control fPDecimal text-right" id="purchase_invoice_ledger_<?php echo $ledger_row; ?>_credit" name="purchase_invoice_ledgers[<?php echo $ledger_row; ?>][credit]" value="<?php echo $ledger['credit']; ?>" />
                                                    </td>
                                                </tr>

                                                <?php $ledger_row++; ?>
                                                <?php endforeach; ?>
                                                </tbody>
                                                <tfoot>
                                                <tr>
                                                    <td></td>
                                                    <td></td>
                                                    <td>
                                                        <input type="text" id="total_debit" name="total_debit" value="<?php echo $total_debit; ?>" class="form-control fDecimal" readonly="readonly" />
                                                    </td>
                                                    <td>
                                                        <input type="text" id="total_credit" name="total_credit" value="<?php echo $total_credit; ?>" class="form-control fDecimal" readonly="readonly" />
                                                        <label hidden="hidden" id="DebitCreditError" style="color: red;">Debit and Credit Amount must be equal.</label>
                                                    </td>
                                                </tr>
                                                </tfoot>
                                            </table>
                                        </div>
                                    </div>
                                    <div class="col-sm-5">
                                        <div class="table-responsive">
                                            <table id="tblExpense" class="table table-bordered">
                                                <thead>
                                                <tr>
                                                    <th style="min-width: 5px; max-width: :5px; !important;">
                                                        <a class="btnAddExpense btn btn-xs btn-primary" title="Add" href="javascript:void(0);"><i class="fa fa-plus"></i></a>
                                                    </th>
                                                    <th class="text-center"><?php echo $lang['expense_head']; ?></th>
                                                    <th class="text-center"><?php echo $lang['expense_amount']; ?></th>
                                                </tr>
                                                </thead>
                                                <tbody>
                                                <?php $expense_row=0; $total_expense=0;?>
                                                <?php foreach($purchase_invoice_expenses as $expense): ?>
                                                <tr id="expense_row_<?php echo $expense_row; ?>" data-expense_row="<?php echo $expense_row; ?>">
                                                    <td>
                                                        <a onclick="removeExpense(this);" title="Remove" class="btn btn-xs btn-danger" href="javascript:void(0);"><i class="fa fa-times"></i></a>
                                                    </td>
                                                    <td>
                                                        <select class="form-control" id="purchase_invoice_expense_<?php echo $expense_row; ?>_inventory_expense_id" name="purchase_invoice_expenses[<?php echo $expense_row; ?>][inventory_expense_id]">
                                                            <option value="">&nbsp;</option>
                                                            <?php foreach($inventory_expenses as $exp): ?>
                                                            <option value="<?php echo $exp['inventory_expense_id']; ?>" <?php echo ($exp['inventory_expense_id']==$expense['inventory_expense_id']?'selected':'');?>><?php echo $exp['name']; ?></option>
                                                            <?php endforeach; ?>
                                                        </select>
                                                    </td>
                                                    <td>
                                                        <input onchange="calculateExpense(this);" type="text" class="form-control fPDecimal text-right" id="purchase_invoice_expense_<?php echo $expense_row; ?>_expense_amount" name="purchase_invoice_expenses[<?php echo $expense_row; ?>][expense_amount]" value="<?php echo $expense['expense_amount']; ?>" />
                                                    </td>
                                                </tr>
                                                <?php $expense_row++; $total_expense += $expense['expense_amount']; ?>
                                                <?php endforeach; ?>
                                                </tbody>
                                                <tfoot>
                                                <tr>
                                                    <td></td>
                                                    <td></td>
                                                    <td>
                                                        <input type="text" id="total_expense" name="total_expense" value="<?php echo $total_expense; ?>" class="form-control fDecimal" readonly="readonly" />
                                                    </td>
                                                </tr>
                                                </tfoot>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </form>
                        </div>
                        <div class="box-footer">
                            <div class="pull-right">
                                <?php if(isset($isEdit) && $isEdit==1): ?>
                                <?php if($is_post == 0): ?>
                                <a class="btn btn-info" href="<?php echo $action_post; ?>">
                                    <i class="fa fa-thumbs-up"></i>
                                    &nbsp;<?php echo $lang['post']; ?>
                                </a>
                                <?php endif; ?>
                                <button type="button" class="btn btn-info" href="javascript:void(0);" onclick="getDocumentLedger();">
                                    <i class="fa fa-balance-scale"></i>
                                    &nbsp;<?php echo $lang['ledger']; ?>
                                </button>
                                <a class="btn btn-info" target="_blank" href="<?php echo $action_print; ?>">
                                    <i class="fa fa-print"></i>
                                    &nbsp;<?php echo $lang['print']; ?>
                                </a>
                                <?php endif; ?>
                                <a class="btn btn-default" href="<?php echo $action_cancel; ?>">
                                    <i class="fa fa-undo"></i>
                                    &nbsp;<?php echo $lang['cancel']; ?>
                                </a>
                                <button type="button" class="btn btn-primary" id= "btnsave" href="javascript:void(0);" onclick="$('#form').submit();" <?php echo ($is_post==1?'disabled="true"':''); ?>>
                                <i class="fa fa-floppy-o"></i>
                                &nbsp;<?php echo $lang['save']; ?>
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
    <link rel="stylesheet" href="plugins/dataTables/dataTables.bootstrap.css">
    <script src="plugins/dataTables/jquery.dataTables.js"></script>
    <script src="plugins/dataTables/dataTables.bootstrap.js"></script>
    <script type="text/javascript" src="../admin/view/js/inventory/purchase_invoice.js"></script>
    <script type="text/javascript" src="plugins/validate/jquery.validate.min.js"></script>
    <script>
        jQuery('#form').validate(<?php echo $strValidation; ?>);
        var $lang = <?php echo json_encode($lang) ?>;
        var $partner_id = '<?php echo $partner_id; ?>';
        var $grid_row = '<?php echo $grid_row; ?>';
        var $ledger_row = '<?php echo $ledger_row; ?>';
        var $expense_row = '<?php echo $expense_row; ?>';
        var $UrlGetRefDocumentNo = '<?php echo $href_get_ref_document_no; ?>';
        var $UrlGetRefDocument = '<?php echo $href_get_ref_document; ?>';
        var $UrlGetProductJSON = '<?php echo $href_get_product_json; ?>';
        var $warehouses = <?php echo json_encode($warehouses) ?>;
        var $coas = <?php echo json_encode($coas) ?>;
        var $inventory_expenses = <?php echo json_encode($inventory_expenses) ?>;

        function formatRepo (repo) {
            if (repo.loading) return repo.text;

            var markup = "<div class='select2-result-repository clearfix'>";
            if(repo.image_url) {
                markup +="<div class='select2-result-repository__avatar'><img src='" + repo.image_url + "' /></div>";
            }
            markup +="<div class='select2-result-repository__meta'>";
            markup +="  <div class='select2-result-repository__title'>" + repo.name + "</div>";

            if (repo.description) {
                markup += "<div class='select2-result-repository__description'>" + repo.description + "</div>";
            }

            markup += "<div class='select2-result-repository__statistics'>" +
                "   <div class='help-block'>" + repo.length + " X " + repo.width + " X " + repo.thickness + "</div>" +
                "</div>" +
                "</div></div>";

            return markup;
        }

        function formatRepoSelection (repo) {
            return repo.name || repo.text;
        }

        <?php if($this->request->get['purchase_invoice_id']): ?>
        $(document).ready(function() {
            $('#partner_type_id').trigger('change');
            $('select.product').select2({
                width: '100%',
                ajax: {
                    url: $UrlGetProductJSON,
                    dataType: 'json',
                    type: 'post',
                    mimeType:"multipart/form-data",
                    delay: 250,
                    data: function (params) {
                        return {
                            q: params.term, // search term
                            page: params.page
                        };
                    },
                    processResults: function (data, params) {
                        // parse the results into the format expected by Select2
                        // since we are using custom formatting functions we do not need to
                        // alter the remote JSON data, except to indicate that infinite
                        // scrolling can be used
                        params.page = params.page || 1;

                        return {
                            results: data.items,
                            pagination: {
                                more: (params.page * 30) < data.total_count
                            }
                        };
                    },
                    cache: true
                },
                escapeMarkup: function (markup) { return markup; }, // let our custom formatter work
                minimumInputLength: 5,
                templateResult: formatRepo, // omitted for brevity, see the source of this page
                templateSelection: formatRepoSelection // omitted for brevity, see the source of this page                }
            });

            calculateTotal();
        });
        <?php endif; ?>
    </script>
    <?php echo $page_footer; ?>
    <?php echo $column_right; ?>
</div><!-- ./wrapper -->
<?php echo $footer; ?>
</body>
</html>