<!DOCTYPE html>
<html>
<?php echo $header; ?>
<body class="hold-transition skin-blue sidebar-mini sidebar-collapse">
<div class="wrapper">
    <?php echo $page_header; ?>
    <?php echo $column_left; ?>
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <h1><?php echo $lang['heading_title']; ?></h1>
            <div class="row">
                <div class="col-sm-6">
                    <ol class="breadcrumb">
                        <?php foreach($breadcrumbs as $breadcrumb): ?>
                        <li>
                            <a href="<?php echo $breadcrumb['href']; ?>">
                                <i class="<?php echo $breadcrumb['class']; ?>"></i>
                                <?php echo $breadcrumb['text']; ?>
                            </a>
                        </li>
                        <?php endforeach; ?>
                    </ol>
                </div>
                <div class="col-sm-6">
                    <div class="pull-right">
                        <a class="btn btn-default" href="<?php echo $action_cancel; ?>">
                            <i class="fa fa-undo"></i>
                            &nbsp;<?php echo $lang['cancel']; ?>
                        </a>
                        <a class="btn btn-primary" href="javascript:void(0);" onclick="$('#form').submit();">
                            <i class="fa fa-floppy-o"></i>
                            &nbsp;<?php echo $lang['save']; ?>
                        </a>
                    </div>
                </div>
            </div>
        </section>
        <!-- Main content -->
        <section class="content">
            <div class="row">
                <div class="col-sm-12">
                    <div class="box">
                        <div class="box-header">
                            <?php if ($error_warning) { ?>
                            <div class="alert alert-danger alert-dismissable">
                                <button class="close" aria-hidden="true" data-dismiss="alert" type="button">x</button>
                                <?php echo $error_warning; ?>
                            </div>
                            <?php } ?>
                            <?php  if ($success) { ?>
                            <div class="alert alert-success alert-dismissable">
                                <button class="close" aria-hidden="true" data-dismiss="alert" type="button">x</button>
                                <?php echo $success; ?>
                            </div>
                            <?php  } ?>
                        </div><!-- /.box-header -->
                        <div class="box-body">
                            <form  action="<?php echo $action; ?>" method="post" enctype="multipart/form-data" id="form">
                                <div class="row">
                                    <div class="col-sm-6">
                                        <div class="form-group">
                                            <label><?php echo $lang['product_category']; ?></label>
                                            <select class="form-control" id="product_category_id" name="product_category_id" >
                                                <option value="">&nbsp;</option>
                                                <?php foreach($product_categories as $product_category): ?>
                                                <option value="<?php echo $product_category['product_category_id']; ?>" <?php echo ($product_category['product_category_id'] == $product_category_id ? 'selected="selected"': ''); ?>><?php echo $product_category['name']; ?></option>
                                                <?php endforeach; ?>
                                            </select>
                                            <label for="product_category_id" class="error" style="display: none;">&nbsp;</label>
                                        </div>
                                        <div class="form-group">
                                            <label><?php echo $lang['thickness']; ?></label>
                                            <select class="form-control" id="thickness_id" name="thickness_id" >
                                                <option value="">&nbsp;</option>
                                                <?php foreach($thicknesses as $thickness): ?>
                                                <option value="<?php echo $thickness['thickness_id']; ?>" <?php echo ($thickness['thickness_id'] == $thickness_id ? 'selected="selected"': ''); ?>><?php echo $thickness['name']; ?></option>
                                                <?php endforeach; ?>
                                            </select>
                                            <label for="thickness_id" class="error" style="display: none;">&nbsp;</label>
                                        </div>
                                        <div class="form-group">
                                            <label><?php echo $lang['width']; ?></label>
                                            <select class="form-control" id="width_id" name="width_id" >
                                                <option value="">&nbsp;</option>
                                                <?php foreach($widths as $width): ?>
                                                <option value="<?php echo $width['width_id']; ?>" <?php echo ($width['width_id'] == $width_id ? 'selected="selected"': ''); ?>><?php echo $width['name']; ?></option>
                                                <?php endforeach; ?>
                                            </select>
                                            <label for="width_id" class="error" style="display: none;">&nbsp;</label>
                                        </div>
                                        <div class="form-group">
                                            <label><?php echo $lang['length']; ?></label>
                                            <select class="form-control" id="length_id" name="length_id" >
                                                <option value="">&nbsp;</option>
                                                <?php foreach($lengths as $length): ?>
                                                <option value="<?php echo $length['length_id']; ?>" <?php echo ($length['length_id'] == $length_id ? 'selected="selected"': ''); ?>><?php echo $length['name']; ?></option>
                                                <?php endforeach; ?>
                                            </select>
                                            <label for="length_id" class="error" style="display: none;">&nbsp;</label>
                                        </div>
                                        <div class="form-group">
                                            <label><?php echo $lang['grade']; ?></label>
                                            <select class="form-control" id="grade_id" name="grade_id" >
                                                <option value="">&nbsp;</option>
                                                <?php foreach($grades as $grade): ?>
                                                <option value="<?php echo $grade['grade_id']; ?>" <?php echo ($grade['grade_id'] == $grade_id ? 'selected="selected"': ''); ?>><?php echo $grade['name']; ?></option>
                                                <?php endforeach; ?>
                                            </select>
                                            <label for="grade_id" class="error" style="display: none;">&nbsp;</label>
                                        </div>
                                        <div class="form-group">
                                            <label><?php echo $lang['sawmill']; ?></label>
                                            <select class="form-control" id="sawmill_id" name="sawmill_id" >
                                                <option value="">&nbsp;</option>
                                                <?php foreach($sawmills as $sawmill): ?>
                                                <option value="<?php echo $sawmill['sawmill_id']; ?>" <?php echo ($sawmill['sawmill_id'] == $sawmill_id ? 'selected="selected"': ''); ?>><?php echo $sawmill['name']; ?></option>
                                                <?php endforeach; ?>
                                            </select>
                                            <label for="sawmill_id" class="error" style="display: none;">&nbsp;</label>
                                        </div>
                                    </div>
                                    <div class="col-sm-6">
                                        <div class="form-group">
                                            <label><span class="required">*</span>&nbsp;<?php echo $lang['code']; ?></label>
                                            <input type="text" class="form-control" name="product_code" id="product_code" value="<?php echo $product_code ?>" <?php echo ($auto_generate_product_code==1?'readonly':'')?> />
                                        </div>
                                        <div class="form-group">
                                            <label><span class="required">*</span>&nbsp;<?php echo $lang['name']; ?></label>
                                            <input class="form-control" type="text" name="name" id="name" value="<?php echo $name; ?>" />
                                        </div>
                                        <div class="form-group">
                                            <label><span class="required">*</span>&nbsp;<?php echo $lang['unit']; ?></label>
                                            <select class="form-control" id="unit_id" name="unit_id" >
                                                <option value="">&nbsp;</option>
                                                <?php foreach($units as $unit): ?>
                                                <option value="<?php echo $unit['unit_id']; ?>" <?php echo ($unit['unit_id'] == $unit_id ? 'selected="selected"': ''); ?>><?php echo $unit['name']; ?></option>
                                                <?php endforeach; ?>
                                            </select>
                                            <label for="unit_id" class="error" style="display: none;"><?php echo $error['unit_id']; ?></label>
                                        </div>
                                        <div class="form-group">
                                            <label><?php echo $lang['cost_price']; ?></label>
                                            <input class="form-control" type="text" name="cost_price" value="<?php echo $cost_price; ?>" />
                                        </div>
                                        <div class="form-group">
                                            <label><?php echo $lang['sale_price']; ?></label>
                                            <input class="form-control" type="text" name="sale_price" value="<?php echo $sale_price; ?>" />
                                        </div>
                                        <div class="form-group">
                                            <label><?php echo $lang['reorder_quantity']; ?></label>
                                            <input class="form-control" type="text" name="reorder_quantity" value="<?php echo $reorder_quantity; ?>" />
                                        </div>
                                    </div>
                                </div>
                                <hr />
                                <div class="row">
                                    <div class="col-sm-6">
                                        <div class="row">
                                            <div class="col-sm-12">
                                                <div class="form-group">
                                                    <label><?php echo $lang['thickness_value']; ?></label>
                                                    <input class="form-control" id="thickness_value" name="thickness_value" value="<?php echo $thickness_value; ?>" />
                                                </div>
                                                <div class="form-group">
                                                    <label><?php echo $lang['width_value']; ?></label>
                                                    <input class="form-control" id="width_value" name="width_value" value="<?php echo $width_value; ?>" />
                                                </div>
                                                <div class="form-group">
                                                    <label><?php echo $lang['length_value']; ?></label>
                                                    <input class="form-control" id="length_value" name="length_value" value="<?php echo $length_value; ?>" />
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="col-sm-6">
                                                <div class="form-group">
                                                    <label><?php echo $lang['cubic_meter']; ?></label>
                                                    <input class="form-control" id="cubic_meter" name="cubic_meter" value="<?php echo $cubic_meter; ?>" />
                                                </div>
                                            </div>
                                            <div class="col-sm-6">
                                                <div class="form-group">
                                                    <label><?php echo $lang['cubic_feet']; ?></label>
                                                    <input class="form-control" id="cubic_feet" name="cubic_feet" value="<?php echo $cubic_feet; ?>" />
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-sm-6">
                                        <div class="form-group">
                                            <label><?php echo $lang['cogs_account']; ?></label>
                                            <select class="form-control" id="cogs_account_id" name="cogs_account_id" >
                                                <!-- <option value="">&nbsp;</option> -->
                                                <?php foreach($cogs_accounts as $coa): ?>
                                                <option value="<?php echo $coa['coa_level3_id']; ?>" <?php echo ($coa['coa_level3_id'] == $cogs_account_id ? 'selected="selected"': ''); ?>><?php echo $coa['level3_display_name']; ?></option>
                                                <?php endforeach; ?>
                                            </select>
                                            <label for="cogs_account_id" class="error" style="display: none;">&nbsp;</label>
                                        </div>
                                        <div class="form-group">
                                            <label><span class="required">*</span>&nbsp;<?php echo $lang['inventory_account']; ?></label>
                                            <select class="form-control" id="inventory_account_id" name="inventory_account_id" >
                                                <!-- <option value="">&nbsp;</option> -->
                                                <?php foreach($inventory_accounts as $coa): ?>
                                                <option value="<?php echo $coa['coa_level3_id']; ?>" <?php echo ($coa['coa_level3_id'] == $inventory_account_id ? 'selected="selected"': ''); ?>><?php echo $coa['level3_display_name']; ?></option>
                                                <?php endforeach; ?>
                                            </select>
                                            <label for="inventory_account_id" class="error" style="display: none;">&nbsp;</label>
                                        </div>
                                        <div class="form-group">
                                            <label><span class="required">*</span>&nbsp;<?php echo $lang['revenue_account']; ?></label>
                                            <select class="form-control" id="revenue_account_id" name="revenue_account_id" >
                                                <!-- <option value="">&nbsp;</option> -->
                                                <?php foreach($revenue_accounts as $coa): ?>
                                                <option value="<?php echo $coa['coa_level3_id']; ?>" <?php echo ($revenue_account_id == $coa['coa_level3_id']?'selected="selected"':''); ?>"><?php echo $coa['level3_display_name']; ?></option>
                                                <?php endforeach; ?>
                                            </select>
                                            <label for="revenue_account_id" class="error" style="display: none;">&nbsp;</label>
                                        </div>
                                        <div class="form-group">
                                            <label><span class="required">*</span>&nbsp;<?php echo $lang['adjustment_account']; ?></label>
                                            <select class="form-control" id="adjustment_account_id" name="adjustment_account_id" >
                                                <!-- <option value="">&nbsp;</option> -->
                                                <?php foreach($adjustment_accounts as $adjustment): ?>
                                                <option value="<?php echo $adjustment['coa_level3_id']; ?>" <?php echo ($adjustment_account_id == $adjustment['coa_level3_id']?'selected="selected"':''); ?>><?php echo $adjustment['level3_display_name']; ?></option>
                                                <?php endforeach; ?>
                                            </select>
                                            <label for="adjustment_account_id" class="error" style="display: none;">&nbsp;</label>
                                        </div>
                                    </div>
                                </div>
                            </form>
                        </div>
                        <div class="box-footer">
                            <div class="pull-right">
                                <a class="btn btn-default" href="<?php echo $action_cancel; ?>">
                                    <i class="fa fa-undo"></i>
                                    &nbsp;<?php echo $lang['cancel']; ?>
                                </a>
                                <a class="btn btn-primary" href="javascript:void(0);" onclick="$('#form').submit();">
                                    <i class="fa fa-floppy-o"></i>
                                    &nbsp;<?php echo $lang['save']; ?>
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
    <script type="text/javascript" src="../admin/view/js/inventory/product.js"></script>
    <script type="text/javascript" src="plugins/validate/jquery.validate.min.js"></script>
    <script>
        jQuery('#form').validate(<?php echo $strValidation; ?>);
    </script>
    <?php echo $page_footer; ?>
    <?php echo $column_right; ?>
</div><!-- ./wrapper -->
<?php echo $footer; ?>
</body>
</html>
