<?php

class ModelSetupFiscalPeriod extends HModel {

    protected function getAlias() {
        return 'setup/fiscal_period';
    }
    
    protected function getTable() {
        return 'fiscal_period';
    }
    
    public function add($document, $data) {
        $this->hinsert($document, $this->getTable(), $data);
//        $this->conn->query("INSERT INTO `" . DB_PREFIX . "user` SET username = '" . $this->conn->escape($data['username']) . "', password = '" . $this->conn->escape(md5($data['password'])) . "', firstname = '" . $this->conn->escape($data['firstname']) . "', lastname = '" . $this->conn->escape($data['lastname']) . "', email = '" . $this->conn->escape($data['email']) . "', user_group_id = '" . (int) $data['user_group_id'] . "', status = '" . (int) $data['status'] . "', date_added = NOW()");
    }

    public function edit($document, $primary_key, $data) {
        $this->hupdate($document, $this->getTable(), $primary_key, $data);
    }

    public function delete($document, $primary_key) {
        $this->hdelete($document, $this->getTable(), $primary_key);
//        $this->conn->query("DELETE FROM `" . DB_PREFIX . "user` WHERE user_id = '" . (int) $user_id . "'");
    }

    public function getFiscalYear($primary_key) {
        $query = $this->conn->query("SELECT * FROM `" . DB_PREFIX . "fiscal_period` WHERE fiscal_period_id = '" . $primary_key . "'");
        return $query->row;
    }

    public function getFiscalYears($data = array()) {
        $sql = "SELECT * FROM `" . DB_PREFIX . "fiscal_period`";

        $sort_data = array(
            'title',
            'status',
            'created_at'
        );

        if (isset($data['sort']) && in_array($data['sort'], $sort_data)) {
            $sql .= " ORDER BY " . $data['sort'];
        } else {
            $sql .= " ORDER BY title";
        }

        if (isset($data['order']) && ($data['order'] == 'DESC')) {
            $sql .= " DESC";
        } else {
            $sql .= " ASC";
        }

        if (isset($data['start']) || isset($data['limit'])) {
            if ($data['start'] < 0) {
                $data['start'] = 0;
            }

            if ($data['limit'] < 1) {
                $data['limit'] = 20;
            }

            $sql .= " LIMIT " . (int) $data['start'] . "," . (int) $data['limit'];
        }

        $query = $this->conn->query($sql);

        return $query->rows;
    }

    public function getTotalFiscalYears() {
        $query = $this->conn->query("SELECT COUNT(*) AS total FROM `" . DB_PREFIX . "fiscal_period`");

        return $query->row['total'];
    }
    
    public function getFiscalPeriodByFiscalYear($fiscal_year_id) {
        $query = $this->conn->query("SELECT * FROM `" . DB_PREFIX . "fiscal_period` WHERE fiscal_year_id = '" . $fiscal_year_id . "' ORDER BY start_date");
        return $query->rows;
    }

}

?>