<?php

class ModelSetupCompanyCurrency extends HModel {

    protected function getTable() {
        return 'company_currency';
    }

    public function add($document, $data) {
        $company_currency_id = $this->hinsert($document, $this->getTable(), $data);
        return $company_currency_id;
//        $this->conn->query("INSERT INTO `" . DB_PREFIX . "user` SET username = '" . $this->conn->escape($data['username']) . "', password = '" . $this->conn->escape(md5($data['password'])) . "', firstname = '" . $this->conn->escape($data['firstname']) . "', lastname = '" . $this->conn->escape($data['lastname']) . "', email = '" . $this->conn->escape($data['email']) . "', user_group_id = '" . (int) $data['user_group_id'] . "', status = '" . (int) $data['status'] . "', date_added = NOW()");
    }

    public function edit($document, $primary_key, $data) {
        $this->hupdate($document, $this->getTable(), $primary_key, $data);
    }

    public function delete($document, $primary_key) {
        $this->hdelete($document, $this->getTable(), $primary_key);
//        $this->conn->query("DELETE FROM `" . DB_PREFIX . "user` WHERE user_id = '" . (int) $user_id . "'");
    }

    public function deleteByData($document, $data) {
        $sql = "SELECT * FROM `" . DB_PREFIX . "company_currency`";
        $sql .= " WHERE";
        foreach ($data as $column => $value) {
            $sql .= " `" . $column . "` = '" . $value . "'";
        }
        $query = $this->conn->query($sql);
        $rows = $query->rows;
        foreach ($rows as $row) {
            $this->hdelete($document, $this->getTable(), $row['company_currency_id']);
        }
//        $this->conn->query("DELETE FROM `" . DB_PREFIX . "user` WHERE user_id = '" . (int) $user_id . "'");
    }

    public function getCompanyCurrency($primary_key) {
        $query = $this->conn->query("SELECT * FROM `" . DB_PREFIX . "company_currency` WHERE company_currency_id = '" . $primary_key . "'");
        return $query->row;
    }

    public function getCompanyCurrencys($data = array()) {
        $sql = "SELECT * FROM `" . DB_PREFIX . "company_currency`";
        if (!empty($data)) {
            $sql .= " WHERE";
            foreach ($data as $column => $value) {
                $sql .= " `" . $column . "` = '" . $value . "' AND";
            }

            $sql = substr($sql, 0, strlen($sql) - 3);
        }

        $query = $this->conn->query($sql);

        return $query->rows;
    }

    public function getCompanyCurrencysArray($data = array()) {
        $rows = $this->getCompanyCurrencys($data);
        $arrCompanyCurrencys = array();
        foreach ($rows as $row) {
            $arrCompanyCurrencys[$row['company_currency_id']] = $row['name'];
        }

        return $arrCompanyCurrencys;
    }

    public function updateCurrencies($company_id) {
        if (extension_loaded('curl')) {
            $data = array();

            $sql = "SELECT *";
            $sql .= " FROM `" . DB_PREFIX . "company`";
            $sql .= " WHERE status = 1";
            
            $sql = "SELECT *";
            $sql .= " FROM `" . DB_PREFIX . "currency`";
            $sql .= " WHERE status = 1";
            
            $query = $this->conn->query($sql);
            foreach ($query->rows as $result) {
                $data[] = $this->config->get('config_currency') . $result['code'] . '=X';
            }

            $curl = curl_init();

            $url = 'http://download.finance.yahoo.com/d/quotes.csv?s=' . implode(',', $data) . '&f=sl1&e=.csv';
            curl_setopt($curl, CURLOPT_URL, $url);
            curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);

            $content = curl_exec($curl);

            curl_close($curl);

            $lines = explode("\n", trim($content));

            foreach ($lines as $line) {
                $currency = utf8_substr($line, 4, 3);
                $value = utf8_substr($line, 11, 6);

                if ((float) $value) {
                    $this->conn->query("UPDATE " . DB_PREFIX . "currency SET value = '" . (float) $value . "', date_modified = '" . $this->conn->escape(date('Y-m-d H:i:s')) . "' WHERE code = '" . $this->conn->escape($currency) . "'");
                }
            }

            $this->conn->query("UPDATE " . DB_PREFIX . "currency SET value = '1.00000', date_modified = '" . $this->conn->escape(date('Y-m-d H:i:s')) . "' WHERE code = '" . $this->conn->escape($this->config->get('config_currency')) . "'");

            $this->cache->delete('currency');
        }
    }

    public function getCompanyCurrencyRate($company_id, $currency_id, $date = '') {
        if($date == '') {
            $date=  MySqlDate();
        } 
        
        $sql = "SELECT *";
        $sql .= " FROM `" . DB_PREFIX . "company_currency`";
        $sql .= " WHERE company_id = '$company_id'";
        $sql .= " AND currency_id = '$currency_id'";
        $sql .= " AND date <= '$date'";
        $sql .= " ORDER BY date DESC";
        $sql .= " LIMIT 1";

        $query = $this->conn->query($sql);
        $row = $query->row;
        
//        d(array($company_id, $currency_code, $date, $sql, $row));
        return (isset($row['rate'])?$row['rate']:0);
    }

}

?>