<?php
class ControllerVehicleWorkOrder extends HController {
    protected $document_type_id = 29;

    protected function getAlias() {
        return 'vehicle/work_order';
    }

    protected function getPrimaryKey() {
        return 'work_order_id';
    }

    protected function getList() {
        parent::getList();
        $this->data['action_ajax'] = $this->url->link($this->getAlias() . '/getAjaxLists', 'token=' . $this->session->data['token'], 'SSL');
        $this->response->setOutput($this->render());
    }

    public function getAjaxLists() {
        $lang = $this->load->language('vehicle/work_order');
        $this->model[$this->getAlias()] = $this->load->model($this->getAlias());
        $data = array();
        $aColumns = array('action', 'document_identity', 'document_date', 'supplier_id','commodity','created_at');

        /*
         * Paging
         */
        $sLimit = "";
        if (isset($_GET['iDisplayStart']) && $_GET['iDisplayLength'] != '-1') {
            $data['criteria']['start'] = $_GET['iDisplayStart'];
            $data['criteria']['limit'] = $_GET['iDisplayLength'];
        }
        /*
         * Ordering
         */
        $sOrder = "";
        if (isset($_GET['iSortCol_0'])) {
            $sOrder = " ORDER BY  ";
            for ($i = 0; $i < intval($_GET['iSortingCols']); $i++) {
                if ($_GET['bSortable_' . intval($_GET['iSortCol_' . $i])] == "true") {
                    $sOrder .= "`" . $aColumns[intval($_GET['iSortCol_' . $i])] . "` " .
                        ($_GET['sSortDir_' . $i] === 'asc' ? 'asc' : 'desc') . ", ";
                }
            }
            $sOrder = substr_replace($sOrder, "", -2);
            if ($sOrder == " ORDER BY") {
                $sOrder = "";
            }
            $data['criteria']['orderby'] = $sOrder;
        }
        /*
         * Filtering
         * NOTE this does not match the built-in DataTables filtering which does it
         * word by word on any field. It's possible to do here, but concerned about efficiency
         * on very large tables, and MySQL's regex functionality is very limited
         */
        $sWhere = "";
        if (isset($_GET['sSearch']) && $_GET['sSearch'] != "") {
            $sWhere = "WHERE (";
            for ($i = 0; $i < count($aColumns); $i++) {
                if (isset($_GET['bSearchable_' . $i]) && $_GET['bSearchable_' . $i] == "true" && $_GET['sSearch'] != '') {
                    $sWhere .= "`" . $aColumns[$i] . "` LIKE '%" . $this->db->escape($_GET['sSearch']) . "%' OR ";
                }
            }
            $sWhere = substr_replace($sWhere, "", -3);
            $sWhere .= ')';
        }
        /* Individual column filtering */
        for ($i = 0; $i < count($aColumns); $i++) {
            if (isset($_GET['bSearchable_' . $i]) && $_GET['bSearchable_' . $i] == "true" && $_GET['sSearch_' . $i] != '') {
                if ($sWhere == "") {
                    $sWhere = "WHERE ";
                } else {
                    $sWhere .= " AND ";
                }
                $sWhere .= "`" . $aColumns[$i] . "` LIKE '%" . $this->db->escape($_GET['sSearch_' . $i]) . "%' ";
            }
        }
        if ($sWhere != "") {
            $sWhere .= " AND company_id = '" . $this->session->data['company_id'] . "'";
            $sWhere .= " AND company_branch_id = '" . $this->session->data['company_branch_id'] . "'";
            $sWhere .= " AND fiscal_year_id = '" . $this->session->data['fiscal_year_id'] . "'";
        } else {
            $sWhere .= "WHERE company_id = '" . $this->session->data['company_id'] . "'";
            $sWhere .= " AND company_branch_id = '" . $this->session->data['company_branch_id'] . "'";
            $sWhere .= " AND fiscal_year_id = '" . $this->session->data['fiscal_year_id'] . "'";
        }
        if ($sWhere != "") {
            $data['filter']['RAW'] = substr($sWhere, 5, strlen($sWhere) - 5);
        }
        //d($data);
        $results = $this->model[$this->getAlias()]->getLists($data);
        // d($results,true);
        $iFilteredTotal = $results['total'];
        $iTotal = $results['table_total'];
        /*
         * Output
         */
        $output = array(
            "sEcho" => intval($_GET['sEcho']),
            "iTotalRecords" => $iTotal,
            "iTotalDisplayRecords" => $iFilteredTotal,
            "aaData" => array()
        );
        foreach ($results['lists'] as $aRow) {
            $row = array();
            $actions = array();
            $actions[] = array(
                'text' => $lang['edit'],
                'href' => $this->url->link($this->getAlias() . '/update', 'token=' . $this->session->data['token'] . '&' . $this->getPrimaryKey() . '=' . $aRow[$this->getPrimaryKey()], 'SSL'),
                'btn_class' => 'btn btn-primary btn-xs',
                'class' => 'fa fa-pencil'
            );
            if($aRow['is_post'] == 0) {
                $actions[] = array(
                    'text' => $lang['delete'],
                    'href' => 'javascript:void(0);',
                    'click' => "ConfirmDelete('" . $this->url->link($this->getAlias() . '/delete', 'token=' . $this->session->data['token'] . '&id=' . $aRow[$this->getPrimaryKey()], 'SSL') . "')",
                    'btn_class' => 'btn btn-danger btn-xs',
                    'class' => 'fa fa-times'
                );
                $actions[] = array(
                    'text' => $lang['post'],
                    'href' => $this->url->link($this->getAlias() . '/post', 'token=' . $this->session->data['token'] . '&' . $this->getPrimaryKey() . '=' . $aRow[$this->getPrimaryKey()], 'SSL'),
                    'btn_class' => 'btn btn-info btn-xs',
                    'class' => 'fa fa-thumbs-up'
                );
            }

            $strAction = '';
            foreach ($actions as $action) {
                $strAction .= '<a '.(isset($action['btn_class'])?'class="'.$action['btn_class'].'"':'').' '.(isset($action['target'])?'target="'.$action['target'].'"':'').' href="' . $action['href'] . '" data-toggle="tooltip" title="' . $action['text'] . '" ' . (isset($action['click']) ? 'onClick="' . $action['click'] . '"' : '') . '>';
                if (isset($action['class'])) {
                    $strAction .= '<span class="' . $action['class'] . '"></span>';
                } else {
                    $strAction .= $action['text'];
                }
                $strAction .= '</a>&nbsp;';
            }
            for ($i = 0; $i < count($aColumns); $i++) {
                if ($aColumns[$i] == 'action') {
                    $row[] = $strAction;
                } elseif ($aColumns[$i] == 'document_date') {
                    $row[] = stdDate($aRow['document_date']);
                } elseif ($aColumns[$i] == 'created_at') {
                    $row[] = stdDateTime($aRow['created_at']);
                } else {
                    $row[] = $aRow[$aColumns[$i]];
                }
            }
            $output['aaData'][] = $row;
        }
        echo json_encode($output);
    }

    protected function getForm() {
        parent::getForm();

        $this->data['document_date'] = stdDate();
        $this->data['base_currency_id'] = $this->session->data['base_currency_id'];
        $this->data['base_currency'] = $this->session->data['base_currency_name'];
        $this->data['document_currency_id'] = $this->session->data['base_currency_id'];
        $this->data['conversion_rate'] = "1.00";

        if (isset($this->request->get['work_order_id']) && ($this->request->server['REQUEST_METHOD'] != 'POST')) {
            $result = $this->model[$this->getAlias()]->getRow(array($this->getPrimaryKey() => $this->request->get[$this->getPrimaryKey()]));
            foreach ($result as $field => $value) {
                if ($field == 'document_date') {
                    $this->data[$field] = stdDate($value);
                } else {
                    $this->data[$field] = $value;
                }
            }

            $this->data['document_id'] = $result['work_order_id'];

            $this->model['work_order_commodity'] = $this->load->model('vehicle/work_order_commodity');
            $rows = $this->model['work_order_commodity']->getRows(array('work_order_id' => $result['work_order_id']));
            $this->data['woc'] = array();
            foreach($rows as $row) {
                $this->data['woc'][$result['commodity']][$row['field']] = $row['value'];
            }

            $this->model['work_order_detail'] = $this->load->model('vehicle/work_order_transaction');
            $this->data['work_order_details'] = $this->model['work_order_detail']->getRows(
                array(
                    'work_order_id' => $this->request->get['work_order_id']
                )
            );

            $this->model['ledger'] = $this->load->model('gl/ledger');
            $ledgers = $this->model['ledger']->getRows(array('document_type_id' => $this->document_type_id, 'document_id' => $this->request->get[$this->getPrimaryKey()]),array('sort_order ASC'));
            foreach($ledgers as $ledger) {
                if(isset($this->data['ledgers'][$ledger['coa_id']])) {
                    $this->data['ledgers'][$ledger['coa_id']]['debit'] += $ledger['debit'];
                    $this->data['ledgers'][$ledger['coa_id']]['credit'] += $ledger['credit'];
                } else {
                    $this->data['ledgers'][$ledger['coa_id']] = $ledger;
                }
            }
        }

        $this->model['coa']=$this->load->model('gl/coa_level3');
        $this->data['coas']=$this->model['coa']->getRows(array('company_id' => $this->session->data['company_id']), array('level3_display_name'));
        //d($this->data['coas'], true);

        $this->model['customer'] = $this->load->model('setup/customer');
        $this->data['customers'] = $this->model['customer']->getRows();

        $this->model['supplier'] = $this->load->model('setup/supplier');
        $this->data['suppliers'] = $this->model['supplier']->getRows(array('company_id' => $this->session->data['company_id']));

        $this->model['destination'] = $this->load->model('setup/destination');
        $this->data['destinations'] = $this->model['destination']->getRows(array('company_id' => $this->session->data['company_id']));

        $this->data['action_post'] = $this->url->link($this->getAlias() . '/post', 'token=' . $this->session->data['token'] . '&' . $this->getPrimaryKey() . '=' . $this->request->get[$this->getPrimaryKey()], 'SSL');
        $this->data['action_print'] = $this->url->link($this->getAlias() . '/printDocument', 'token=' . $this->session->data['token'] . '&' . $this->getPrimaryKey() . '=' . $this->request->get[$this->getPrimaryKey()], 'SSL');
        $this->data['action_validate_date'] = $this->url->link('common/function/validateDate', 'token=' . $this->session->data['token']);
        $this->data['strValidation'] = "{
            'rules': {
                'document_date': {'required': true, 'remote':  {url: '" . $this->data['action_validate_date'] . "', type: 'post'}},
                'customer_id': {'required': true},
                'commodity': {'required': true},
            },
        }";
        $this->response->setOutput($this->render());
    }

    protected function insertData($data) {
        $gl_data = array();

        $this->model['document_type'] = $this->load->model('common/document_type');
        $document = $this->model['document_type']->getNextDocument($this->document_type_id);

        $data['document_date'] = MySqlDate($data['document_date']);
        $data['company_id'] = $this->session->data['company_id'];
        $data['company_branch_id'] = $this->session->data['company_branch_id'];
        $data['fiscal_year_id'] = $this->session->data['fiscal_year_id'];
        $data['document_type_id'] = $this->document_type_id;
        $data['document_prefix'] = $document['document_prefix'];
        $data['document_no'] = $document['document_no'];
        $data['document_identity'] = $document['document_identity'];
        $data['base_currency_id'] = $this->session->data['base_currency_id'];
        $data['document_currency_id'] = $this->session->data['base_currency_id'];
        $data['conversion_rate'] = 1;

        $work_order_id = $this->model[$this->getAlias()]->add($this->getAlias(), $data);

        $this->model['company'] = $this->load->model('setup/company');
        $company = $this->model['company']->getRow(array('company_id' => $this->session->data['company_id']));

        $this->model['supplier'] = $this->load->model('setup/supplier');
        $supplier = $this->model['supplier']->getRow(array('supplier_id' => $data['supplier_id']));

        $credit_account_id = $supplier['outstanding_account_id'];
        $sale_tax_account_id = $company['sale_tax_account_id'];
        $this->model['mapping_coa'] = $this->load->model('gl/mapping_coa');
        $row = $this->model['mapping_coa']->getRow(array('company_id' => $this->session->data['company_id'], 'mapping_type_code' => 'ICT'));
        $income_tax_account_id = $row['coa_level3_id'];

        $row = $this->model['mapping_coa']->getRow(array('company_id' => $this->session->data['company_id'], 'mapping_type_code' => 'FR'));
        $freight_account_id = $row['coa_level3_id'];

//////////////////////////// Master Ledger Entry /////////////////////////////////////

        $totalDebit = 0;
        $totalCredit = 0;
        $totalPayable =0;

        $this->model['work_order_commodity'] = $this->load->model('vehicle/work_order_commodity');
        foreach ($data['woc'][$data['commodity']] as $field => $value) {
            $dataDetail = array(
                'work_order_id' => $work_order_id,
                'field' => $field,
                'value' => $value
            );

            if($field == "total")
            {
                $totalDebit += $value;
                $gl_data[] = array(
                    'field' => $field,
                    'ref_document_type_id' => $this->document_type_id,
                    'ref_document_id' => $work_order_id,
                    'ref_document_identity' => $data['document_identity'],
                    'coa_id' => $freight_account_id,
                    'document_debit' => $value,
                    'document_credit' => 0,
                    'debit' => $value,
                    'credit' => 0
                );
            }
            else if($field == "sales_tax_amount")
            {
                $totalDebit += $value;
                $gl_data[] = array(
                    'field' => $field,
                    'ref_document_type_id' => $this->document_type_id,
                    'ref_document_id' => $work_order_id,
                    'ref_document_identity' => $data['document_identity'],
                    'coa_id' => $sale_tax_account_id,
                    'document_debit' => $value,
                    'document_credit' => 0,
                    'debit' => $value,
                    'credit' => 0
                );
            }
            else if($field == "income_tax_amount")
            {
                $totalDebit += $value;

                $gl_data[] = array(
                    'field' => $field,
                    'ref_document_type_id' => $this->document_type_id,
                    'ref_document_id' => $work_order_id,
                    'ref_document_identity' => $data['document_identity'],
                    'coa_id' => $income_tax_account_id,
                    'document_debit' => $value,
                    'document_credit' => 0,
                    'debit' => $value,
                    'credit' => 0
                );
            }
            $this->model['work_order_commodity']->add($this->getAlias(), $dataDetail);

        }
//        d($data,true);

        $this->model['work_order_vehicle'] = $this->load->model('vehicle/work_order_transaction');

        foreach ($data['work_order_details'] as $sort_order => $detail) {
            $detail['work_order_id'] = $work_order_id;
            $detail['sort_order'] = $sort_order;
            $work_order_detail_id = $this->model['work_order_vehicle']->add($this->getAlias(), $detail);
            $totalCredit += $detail['credit'];
            $totalDebit += $detail['debit'];

            $gl_data[] = array(
                'document_detail_id' => $work_order_detail_id,
                'ref_document_type_id' => $data['ref_document_type_id'],
                'ref_document_id' => $data['ref_document_id'],
                'ref_document_identity' => $data['ref_document_identity'],
                'coa_id' => $detail['coa_id'],
                'document_debit' => $detail['debit'],
                'document_credit' => $detail['credit'],
                'debit' => $detail['debit'],
                'credit' => $detail['credit'],
            );
        }

        $totalPayable = $totalDebit - $totalCredit;
        if($totalPayable <0 ) {
            $gl_data[] = array(
                'ref_document_type_id' => $this->document_type_id,
                'ref_document_id' => $work_order_id,
                'ref_document_identity' => $data['document_identity'],
                'coa_id' => $credit_account_id,
                'document_debit' => 0,
                'document_credit' => $totalPayable,
                'debit' => (-1 * $totalPayable),
                'credit' => 0
            );
        } else {
            $gl_data[] = array(
                'ref_document_type_id' => $this->document_type_id,
                'ref_document_id' => $work_order_id,
                'ref_document_identity' => $data['document_identity'],
                'coa_id' => $credit_account_id,
                'document_debit' => 0,
                'document_credit' => $totalPayable,
                'debit' => 0,
                'credit' => $totalPayable
            );
        }

        $this->model['ledger'] = $this->load->model('gl/ledger');
        //d($gl_data, true);
        foreach($gl_data as $sort_order => $ledger) {
            $ledger['company_id'] = $this->session->data['company_id'];
            $ledger['company_branch_id'] = $this->session->data['company_branch_id'];
            $ledger['fiscal_year_id'] = $this->session->data['fiscal_year_id'];
            $ledger['document_type_id'] = $this->document_type_id;
            $ledger['document_id'] = $work_order_id;
            $ledger['document_identity'] = $data['document_identity'];
            $ledger['document_date'] = $data['document_date'];
            $ledger['sort_order'] = $sort_order;
            $ledger['base_currency_id'] = $data['base_currency_id'];
            $ledger['document_currency_id'] = $data['document_currency_id'];
            $ledger['conversion_rate'] = $data['conversion_rate'];
            $ledger['people_type_id'] = 1;
            $ledger['people_id'] = $data['supplier_id'];
            $ledger['remarks'] = '';

            $ledger_id = $this->model['ledger']->add($this->getAlias(), $ledger);
//            d(array($data,$detail,$dataDetail,$ledger,$totalCredit,$totalDebit,$totalPayable),true);
        }

        return $work_order_id;
    }

    protected function insertRedirect($id, $data) {
        $url = $this->getURL();
        $this->redirect($this->url->link($this->getAlias().'/update', 'token=' . $this->session->data['token'] . '&work_order_id=' . $id, 'SSL'));
    }

    protected function updateData($primary_key, $data) {
        $this->model['ledger'] = $this->load->model('gl/ledger');
        $this->model['work_order_detail'] = $this->load->model('vehicle/work_order_transaction');
        $this->model['work_order_commodity'] = $this->load->model('vehicle/work_order_commodity');

        $this->model['ledger']->deleteBulk($this->getAlias(), array('document_type_id' => $this->document_type_id, 'document_id'=>  $primary_key));
        $this->model['work_order_detail']->deleteBulk($this->getAlias(), array('work_order_id'=>  $primary_key));
        $this->model['work_order_commodity']->deleteBulk($this->getAlias(), array('work_order_id'=>  $primary_key));

        $data['base_currency_id'] = $this->session->data['base_currency_id'];
        $data['document_currency_id'] = $this->session->data['base_currency_id'];
        $data['conversion_rate'] = 1;
        $data['document_date'] = MySqlDate($data['document_date']);
        $work_order_id = $this->model[$this->getAlias()]->edit($this->getAlias(), $primary_key, $data);

        $this->model['company'] = $this->load->model('setup/company');
        $company = $this->model['company']->getRow(array('company_id' => $this->session->data['company_id']));

        $this->model['supplier'] = $this->load->model('setup/supplier');
        $supplier = $this->model['supplier']->getRow(array('supplier_id' => $data['supplier_id']));

        $credit_account_id = $supplier['outstanding_account_id'];
        $sale_tax_account_id = $company['sale_tax_account_id'];
        $this->model['mapping_coa'] = $this->load->model('gl/mapping_coa');
        $row = $this->model['mapping_coa']->getRow(array('company_id' => $this->session->data['company_id'], 'mapping_type_code' => 'ICT'));
        $income_tax_account_id = $row['coa_level3_id'];

        $row = $this->model['mapping_coa']->getRow(array('company_id' => $this->session->data['company_id'], 'mapping_type_code' => 'FR'));
        $freight_account_id = $row['coa_level3_id'];

        $totalDebit = 0;
        $totalCredit = 0;
        $totalPayable =0;

        foreach ($data['woc'][$data['commodity']] as $field => $value) {
            $dataDetail = array(
                'work_order_id' => $work_order_id,
                'field' => $field,
                'value' => $value
            );

            if($field == "total")
            {
                $totalDebit += $value;
                $gl_data[] = array(
                    'field' => $field,
                    'ref_document_type_id' => $this->document_type_id,
                    'ref_document_id' => $work_order_id,
                    'ref_document_identity' => $data['document_identity'],
                    'coa_id' => $freight_account_id,
                    'document_debit' => $value,
                    'document_credit' => 0,
                    'debit' => $value,
                    'credit' => 0
                );
            }
            else if($field == "sales_tax_amount")
            {
                $totalDebit += $value;
                $gl_data[] = array(
                    'field' => $field,
                    'ref_document_type_id' => $this->document_type_id,
                    'ref_document_id' => $work_order_id,
                    'ref_document_identity' => $data['document_identity'],
                    'coa_id' => $sale_tax_account_id,
                    'document_debit' => $value,
                    'document_credit' => 0,
                    'debit' => $value,
                    'credit' => 0
                );
            }
            else if($field == "income_tax_amount")
            {
                $totalDebit += $value;

                $gl_data[] = array(
                    'field' => $field,
                    'ref_document_type_id' => $this->document_type_id,
                    'ref_document_id' => $work_order_id,
                    'ref_document_identity' => $data['document_identity'],
                    'coa_id' => $income_tax_account_id,
                    'document_debit' => $value,
                    'document_credit' => 0,
                    'debit' => $value,
                    'credit' => 0
                );
            }
            $this->model['work_order_commodity']->add($this->getAlias(), $dataDetail);

        }

        foreach ($data['work_order_details'] as $sort_order => $detail) {
            $detail['work_order_id'] = $work_order_id;
            $detail['sort_order'] = $sort_order;
            $work_order_detail_id = $this->model['work_order_detail']->add($this->getAlias(), $detail);
            $totalCredit += $detail['credit'];
            $totalDebit += $detail['debit'];

            $gl_data[] = array(
                'document_detail_id' => $work_order_detail_id,
                'ref_document_type_id' => $data['ref_document_type_id'],
                'ref_document_id' => $data['ref_document_id'],
                'ref_document_identity' => $data['ref_document_identity'],
                'coa_id' => $detail['coa_id'],
                'document_debit' => $detail['debit'],
                'document_credit' => $detail['credit'],
                'debit' => $detail['debit'],
                'credit' => $detail['credit'],
            );
        }

        $totalPayable = $totalDebit - $totalCredit;
        if($totalPayable <0 ) {
            $gl_data[] = array(
                'ref_document_type_id' => $this->document_type_id,
                'ref_document_id' => $work_order_id,
                'ref_document_identity' => $data['document_identity'],
                'coa_id' => $credit_account_id,
                'document_debit' => 0,
                'document_credit' => $totalPayable,
                'debit' => (-1 * $totalPayable),
                'credit' => 0
            );
        } else {
            $gl_data[] = array(
                'ref_document_type_id' => $this->document_type_id,
                'ref_document_id' => $work_order_id,
                'ref_document_identity' => $data['document_identity'],
                'coa_id' => $credit_account_id,
                'document_debit' => 0,
                'document_credit' => $totalPayable,
                'debit' => 0,
                'credit' => $totalPayable
            );
        }

        $this->model['ledger'] = $this->load->model('gl/ledger');
        //d($gl_data, true);
        foreach($gl_data as $sort_order => $ledger) {
            $ledger['company_id'] = $this->session->data['company_id'];
            $ledger['company_branch_id'] = $this->session->data['company_branch_id'];
            $ledger['fiscal_year_id'] = $this->session->data['fiscal_year_id'];
            $ledger['document_type_id'] = $this->document_type_id;
            $ledger['document_id'] = $work_order_id;
            $ledger['document_identity'] = $data['document_identity'];
            $ledger['document_date'] = $data['document_date'];
            $ledger['sort_order'] = $sort_order;
            $ledger['base_currency_id'] = $data['base_currency_id'];
            $ledger['document_currency_id'] = $data['document_currency_id'];
            $ledger['conversion_rate'] = $data['conversion_rate'];
            $ledger['people_type_id'] = 1;
            $ledger['people_id'] = $data['supplier_id'];
            $ledger['remarks'] = '';

            $ledger_id = $this->model['ledger']->add($this->getAlias(), $ledger);
        }

        return $work_order_id;
    }

    protected function updateRedirect($id, $data) {
        $url = $this->getURL();
        $this->redirect($this->url->link($this->getAlias().'/update', 'token=' . $this->session->data['token'] . '&work_order_id=' . $id, 'SSL'));
    }

    protected function validateDelete() {
        if (!$this->user->hasPermission('delete', $this->getAlias())) {
            $this->error['warning'] = $this->language->get('error_permission_delete');
        }
        if (!$this->error) {
            return true;
        } else {
            return false;
        }
    }

    protected function deleteData($primary_key) {
        $this->model['work_order_commodity'] = $this->load->model('vehicle/work_order_commodity');
        $this->model['work_order_commodity']->deleteBulk($this->getAlias(),array('work_order_id' => $primary_key));
        $this->model['work_order_vehicle'] = $this->load->model('vehicle/work_order_vehicle');
        $this->model['work_order_vehicle']->deleteBulk($this->getAlias(),array('work_order_id' => $primary_key));
        $this->model[$this->getAlias()]->delete($this->getAlias(), $primary_key);
        $this->model['ledger'] = $this->load->model('gl/ledger');
        $this->model['ledger']->deleteBulk($this->getAlias(), array('company_id' => $this->session->data['company_id'],'document_type_id' => $this->document_type_id, 'document_id' => $primary_key));

    }

}
?>