<?php

class ControllerInventoryStockTransfer extends HController {
    protected $document_type_id = 25;

    protected function getAlias() {
        return 'inventory/stock_transfer';
    }

    protected function getPrimaryKey() {
        return 'stock_transfer_id';
    }

    protected function getList() {
        parent::getList();

        $this->data['action_ajax'] = $this->url->link($this->getAlias() . '/getAjaxLists', 'token=' . $this->session->data['token'], 'SSL');
        $this->response->setOutput($this->render());
    }

    public function getAjaxLists() {
        $lang = $this->load->language('inventory/stock_transfer');
        $this->model[$this->getAlias()] = $this->load->model($this->getAlias());
        $data = array();
        $aColumns = array('action', 'document_date', 'document_identity', 'warehouse', 'total_qty', 'created_at', 'check_box');

        /*
         * Paging
         */
        $sLimit = "";
        if (isset($_GET['iDisplayStart']) && $_GET['iDisplayLength'] != '-1') {
            $data['criteria']['start'] = $_GET['iDisplayStart'];
            $data['criteria']['limit'] = $_GET['iDisplayLength'];
        }

        /*
         * Ordering
         */
        $sOrder = "";
        if (isset($_GET['iSortCol_0'])) {
            $sOrder = " ORDER BY  ";
            for ($i = 0; $i < intval($_GET['iSortingCols']); $i++) {
                if ($_GET['bSortable_' . intval($_GET['iSortCol_' . $i])] == "true") {
                    $sOrder .= "`" . $aColumns[intval($_GET['iSortCol_' . $i])] . "` " .
                        ($_GET['sSortDir_' . $i] === 'asc' ? 'asc' : 'desc') . ", ";
                }
            }

            $sOrder = substr_replace($sOrder, "", -2);
            if ($sOrder == " ORDER BY") {
                $sOrder = "";
            }
            $data['criteria']['orderby'] = $sOrder;
        }


        /*
         * Filtering
         * NOTE this does not match the built-in DataTables filtering which does it
         * word by word on any field. It's possible to do here, but concerned about efficiency
         * on very large tables, and MySQL's regex functionality is very limited
         */
        $arrWhere = array();
        $arrWhere[] = "`company_id` = '".$this->session->data['company_id']."'";
        $arrWhere[] = "`company_branch_id` = '".$this->session->data['company_branch_id']."'";
        $arrWhere[] = "`fiscal_year_id` = '".$this->session->data['fiscal_year_id']."'";
        if (isset($_GET['sSearch']) && $_GET['sSearch'] != "") {
            $arrSSearch = array();
            for ($i = 0; $i < count($aColumns); $i++) {
                if (isset($_GET['bSearchable_' . $i]) && $_GET['bSearchable_' . $i] == "true" && $_GET['sSearch'] != '') {
                    $arrSSearch[] = "LOWER(`" . $aColumns[$i] . "`) LIKE '%" . $this->db->escape(strtolower($_GET['sSearch'])) . "%'";
                }
            }
            if(!empty($arrSSearch)) {
                $arrWhere[] = '(' . implode(' OR ', $arrSSearch) . ')';
            }
        }

        /* Individual column filtering */
        for ($i = 0; $i < count($aColumns); $i++) {
            if (isset($_GET['bSearchable_' . $i]) && $_GET['bSearchable_' . $i] == "true" && $_GET['sSearch_' . $i] != '') {
                $arrWhere[] = "LOWER(`" . $aColumns[$i] . "`) LIKE '%" . $this->db->escape(strtolower($_GET['sSearch_' . $i])) . "%' ";
            }
        }

        if (!empty($arrWhere)) {
            //$data['filter']['RAW'] = substr($sWhere, 5, strlen($sWhere) - 5);
            $data['filter']['RAW'] = implode(' AND ', $arrWhere);
        }

        //d($data, true);
        $results = $this->model[$this->getAlias()]->getLists($data);
        $iFilteredTotal = $results['total'];
        $iTotal = $results['table_total'];


        /*
         * Output
         */
        $output = array(
            "sEcho" => intval($_GET['sEcho']),
            "iTotalRecords" => $iTotal,
            "iTotalDisplayRecords" => $iFilteredTotal,
            "aaData" => array()
        );

        foreach ($results['lists'] as $aRow) {
            $row = array();
            $actions = array();

            $actions[] = array(
                'text' => $lang['edit'],
                'href' => $this->url->link($this->getAlias() . '/update', 'token=' . $this->session->data['token'] . '&' . $this->getPrimaryKey() . '=' . $aRow[$this->getPrimaryKey()], 'SSL'),
                'btn_class' => 'btn btn-primary btn-xs',
                'class' => 'fa fa-pencil'
            );

            $actions[] = array(
                'text' => $lang['print'],
                'target' => '_blank',
                'href' => $this->url->link($this->getAlias() . '/printDocument', 'token=' . $this->session->data['token'] . '&' . $this->getPrimaryKey() . '=' . $aRow[$this->getPrimaryKey()], 'SSL'),
                'btn_class' => 'btn btn-info btn-xs',
                'class' => 'fa fa-print'
            );

            if($aRow['is_post']==0) {
                $actions[] = array(
                    'text' => $lang['post'],
                    'href' => $this->url->link($this->getAlias() . '/post', 'token=' . $this->session->data['token'] . '&' . $this->getPrimaryKey() . '=' . $aRow[$this->getPrimaryKey()], 'SSL'),
                    'btn_class' => 'btn btn-info btn-xs',
                    'class' => 'fa fa-thumbs-up'
                );

                $actions[] = array(
                    'text' => $lang['delete'],
                    'href' => 'javascript:void(0);',
                    'click' => "ConfirmDelete('" . $this->url->link($this->getAlias() . '/delete', 'token=' . $this->session->data['token'] . '&id=' . $aRow[$this->getPrimaryKey()], 'SSL') . "')",
                    'btn_class' => 'btn btn-danger btn-xs',
                    'class' => 'fa fa-times'
                );
            }

            $strAction = '';
            foreach ($actions as $action) {
                $strAction .= '<a '.(isset($action['btn_class'])?'class="'.$action['btn_class'].'"':'').' href="' . $action['href'] .'" '. (isset($action['target']) ? 'target="' . $action['target'] . '"' : '') . ' data-toggle="tooltip" title="' . $action['text'] . '" ' . (isset($action['click']) ? 'onClick="' . $action['click'] . '"' : '') . '>';
                if (isset($action['class'])) {
                    $strAction .= '<span class="' . $action['class'] . '"></span>';
                } else {
                    $strAction .= $action['text'];
                }
                $strAction .= '</a>&nbsp;';
            }

            for ($i = 0; $i < count($aColumns); $i++) {
                if ($aColumns[$i] == 'action') {
                    $row[] = $strAction;
                } elseif ($aColumns[$i] == 'document_date') {
                    $row[] = stdDate($aRow['document_date']);
                } elseif ($aColumns[$i] == 'created_at') {
                    $row[] = stdDateTime($aRow['created_at']);
                } elseif ($aColumns[$i] == 'check_box') {
                    $row[] = '<input type="checkbox" name="selected[]" value="' . $aRow[$this->getPrimaryKey()] . '" />';
                } else {
                    $row[] = $aRow[$aColumns[$i]];
                }

            }
            $output['aaData'][] = $row;
        }

        echo json_encode($output);
    }

    protected function getForm() {
        parent::getForm();

        $this->model['product'] = $this->load->model('inventory/product');
        $this->data['products'] = $this->model['product']->getRows(array('company_id' => $this->session->data['company_id']));

        $this->model['currency'] = $this->load->model('setup/currency');
        $this->data['currencys'] = $this->model['currency']->getRows();

        $this->model['unit'] = $this->load->model('inventory/unit');
        $this->data['units'] = $this->model['unit']->getRows(array('company_id' => $this->session->data['company_id']));
        $arrUnits = $this->model['unit']->getArrays('unit_id','name',array('company_id' => $this->session->data['company_id']));

        $this->model['warehouse'] = $this->load->model('setup/warehouse');
        $this->data['warehouses'] = $this->model['warehouse']->getRows(array('company_id' => $this->session->data['company_id'], 'company_branch_id' => $this->session->data['company_branch_id']));

        $this->data['base_currency_id'] = $this->session->data['base_currency_id'];
        $this->data['base_currency'] = $this->session->data['base_currency_name'];
        $this->data['document_currency_id'] = $this->session->data['base_currency_id'];
        $this->data['conversion_rate'] = "1.00";

        $this->data['document_date'] = stdDate();
        if (isset($this->request->get['stock_transfer_id']) && ($this->request->server['REQUEST_METHOD'] != 'POST')) {
            $this->data['isEdit'] = 1;
            $result = $this->model[$this->getAlias()]->getRow(array($this->getPrimaryKey() => $this->request->get[$this->getPrimaryKey()]));
            //d($result, true);

            foreach ($result as $field => $value) {
                if ($field == 'document_date') {
                    $this->data[$field] = stdDate($value);
                } else {
                    $this->data[$field] = $value;
                }
            }

            $this->model['stock_transfer_detail'] = $this->load->model('inventory/stock_transfer_detail');
            $this->data['stock_transfer_details'] = $this->model['stock_transfer_detail']->getRows(array('stock_transfer_id' => $this->request->get['stock_transfer_id']));
        }

        $this->data['href_get_containers'] = $this->url->link($this->getAlias() . '/getContainers', 'token=' . $this->session->data['token'] . '&' . $this->getPrimaryKey() . '=' . $this->request->get[$this->getPrimaryKey()], 'SSL');
        $this->data['href_get_container_data'] = $this->url->link($this->getAlias() . '/getContainerData', 'token=' . $this->session->data['token'] . '&' . $this->getPrimaryKey() . '=' . $this->request->get[$this->getPrimaryKey()], 'SSL');
        $this->data['action_post'] = $this->url->link($this->getAlias() . '/post', 'token=' . $this->session->data['token'] . '&' . $this->getPrimaryKey() . '=' . $this->request->get[$this->getPrimaryKey()], 'SSL');
        $this->data['action_print'] = $this->url->link($this->getAlias() . '/printDocument', 'token=' . $this->session->data['token'] . '&' . $this->getPrimaryKey() . '=' . $this->request->get[$this->getPrimaryKey()], 'SSL');

        $this->data['action_validate_date'] = $this->url->link('common/function/validateDate', 'token=' . $this->session->data['token']);
        $this->data['strValidation'] = "{
            'rules': {
                'document_date': {'required': true, 'remote':  {url: '" . $this->data['action_validate_date'] . "', type: 'post'}},
                'partner_id': {'required': true},
                'total_qty': {'required': true, 'min':1},
            },
            'ignore': [],
        }";

        $this->response->setOutput($this->render());
    }

    public function getContainers() {
        $post = $this->request->post;
        $warehouse_id = $post['warehouse_id'];
        $this->model['stock'] = $this->load->model('common/stock_ledger');
        $rows = $this->model['stock']->getBalanceContainers(array('warehouse_id' => $warehouse_id));
        $html = '';
        $html .= '<option value="">&nbsp;</option>';
        foreach($rows as $row) {
            $html .= '<option value="'.$row['container_no'].'">'.$row['container_no'].'</option>';
        }
        $json = array(
            'success' => true,
            'html' => $html
        );

        echo json_encode($json);
    }

    public function getContainerData() {
        $post = $this->request->post;
        $warehouse_id = $post['warehouse_id'];
        $container_no = $post['container_no'];
        $this->model['stock'] = $this->load->model('common/stock_ledger');
        $details = $this->model['stock']->getBalanceContainerStocks($container_no, $warehouse_id);
//        d($details, true);
        $json = array(
            'success' => true,
            'details' => $details
        );

        echo json_encode($json);
    }

    protected function insertData($data) {
        $this->model['document_type'] = $this->load->model('common/document_type');
        $document = $this->model['document_type']->getNextDocument($this->document_type_id);

        $data['document_type_id'] = $this->document_type_id;
        $data['document_prefix'] = $document['document_prefix'];
        $data['document_no'] = $document['document_no'];
        $data['document_identity'] = $document['document_identity'];

        $data['company_id'] = $this->session->data['company_id'];
        $data['company_branch_id'] = $this->session->data['company_branch_id'];
        $data['fiscal_year_id'] = $this->session->data['fiscal_year_id'];
        $data['document_date'] = MySqlDate($data['document_date']);
        $data['base_amount'] = $data['total_amount'] * $data['conversion_rate'];

        $stock_transfer_id = $this->model[$this->getAlias()]->add($this->getAlias(), $data);
        $data['document_id'] = $stock_transfer_id;

        $this->model['stock_transfer_detail'] = $this->load->model('inventory/stock_transfer_detail');
        $this->model['document'] = $this->load->model('common/document');
        $this->model['product'] = $this->load->model('inventory/product');
        $this->model['ledger'] = $this->load->model('gl/ledger');
        $this->model['stock_ledger'] = $this->load->model('common/stock_ledger');
        //d($data, true);
        $insert_document = array(
            'company_id' => $this->session->data['company_id'],
            'company_branch_id' => $this->session->data['company_branch_id'],
            'fiscal_year_id' => $this->session->data['fiscal_year_id'],
            'document_type_id' => $this->document_type_id,
            'document_id' => $data['document_id'],
            'document_identity' => $data['document_identity'],
            'document_date' => $data['document_date'],
            'partner_type_id' => $data['partner_type_id'],
            'partner_id' => $data['partner_id'],
            'document_currency_id' => $data['document_currency_id'],
            'document_amount' => $data['total_amount'],
            'conversion_rate' => $data['conversion_rate'],
            'base_currency_id' => $data['base_currency_id'],
            'base_amount' => $data['base_amount'],
        );
        $document_id = $this->model['document']->add($this->getAlias(), $insert_document);
        //d(array($document_id, $document), true);
        $stock_ledger = array();
        foreach ($data['stock_transfer_details'] as $sort_order => $detail) {
            $detail['stock_transfer_id'] = $stock_transfer_id;
            $detail['fiscal_year_id'] = $this->session->data['fiscal_year_id'];
            $detail['company_branch_id'] = $this->session->data['company_branch_id'];
            $detail['company_id'] = $this->session->data['company_id'];
            $detail['sort_order'] = $sort_order;
            $detail['document_currency_id'] = $data['document_currency_id'];
            $detail['base_currency_id'] = $data['base_currency_id'];
            $detail['conversion_rate'] = $data['conversion_rate'];
            $detail['base_cog_rate'] = ($detail['cog_rate'] * $data['conversion_rate']);
            $detail['base_cog_amount'] = ($detail['cog_amount'] * $data['conversion_rate']);
            $stock_transfer_detail_id=$this->model['stock_transfer_detail']->add($this->getAlias(), $detail);

            $stock_ledger[] = array(
                'document_detail_id' => $stock_transfer_detail_id,
                'warehouse_id' => $data['warehouse_id'],
                'manual_ref_no' => $detail['manual_ref_no'],
                'container_no' => $detail['container_no'],
                'batch_no' => $detail['batch_no'],
                'product_id' => $detail['product_id'],
                'document_unit_id' => $detail['unit_id'],
                'document_qty' => $detail['qty'],
                'unit_conversion' => 1,
                'base_unit_id' => $detail['unit_id'],
                'base_qty' => (-1 * $detail['qty']),
                'base_cubic_meter' => (-1 * $detail['total_cubic_meter']),
                'base_cubic_feet' => (-1 * $detail['total_cubic_feet']),
                'document_rate' => $detail['cog_rate'],
                'document_amount' => (-1 * $detail['cog_amount']),
                'base_rate' => ($detail['cog_rate'] * $detail['conversion_rate']),
                'base_amount' => (-1 * $detail['cog_amount'] * $detail['conversion_rate']),
                'remarks' => $data['remarks'],
            );
            $stock_ledger[] = array(
                'document_detail_id' => $stock_transfer_detail_id,
                'warehouse_id' => $detail['warehouse_id'],
                'manual_ref_no' => $detail['manual_ref_no'],
                'container_no' => $detail['container_no'],
                'batch_no' => $detail['batch_no'],
                'product_id' => $detail['product_id'],
                'document_unit_id' => $detail['unit_id'],
                'document_qty' => $detail['qty'],
                'unit_conversion' => 1,
                'base_unit_id' => $detail['unit_id'],
                'base_qty' => ($detail['qty']),
                'base_cubic_meter' => $detail['total_cubic_meter'],
                'base_cubic_feet' => $detail['total_cubic_feet'],
                'document_rate' => $detail['cog_rate'],
                'document_amount' => ($detail['cog_amount']),
                'base_rate' => ($detail['cog_rate'] * $detail['conversion_rate']),
                'base_amount' => ($detail['cog_amount'] * $detail['conversion_rate']),
                'remarks' => $data['remarks'],
            );
        }

        //d($stock_ledger, true);
        foreach($stock_ledger as $sort_order => $ledger) {
            $ledger['company_id'] = $this->session->data['company_id'];
            $ledger['company_branch_id'] = $this->session->data['company_branch_id'];
            $ledger['fiscal_year_id'] = $this->session->data['fiscal_year_id'];
            $ledger['document_type_id'] = $this->document_type_id;
            $ledger['document_id'] = $data['document_id'];
            $ledger['document_identity'] = $data['document_identity'];
            $ledger['document_date'] = $data['document_date'];
            $ledger['sort_order'] = $sort_order;
            $ledger['base_currency_id'] = $data['base_currency_id'];
            $ledger['document_currency_id'] = $data['document_currency_id'];
            $ledger['currency_conversion'] = $data['conversion_rate'];

            $stock_ledger_id = $this->model['stock_ledger']->add($this->getAlias(), $ledger);
            //d(array($stock_ledger_id, $ledger), true);
        }

        return $stock_transfer_id;
    }

    protected function insertRedirect($id, $data) {
        $url = $this->getURL();
        $this->redirect($this->url->link($this->getAlias().'/update', 'token=' . $this->session->data['token'] . '&stock_transfer_id=' . $id, 'SSL'));
    }

    protected function updateData($primary_key, $data) {
        $stock_transfer_id = $primary_key;
        $data['document_date'] = MySqlDate($data['document_date']);

        $this->model['stock_transfer'] = $this->load->model('inventory/stock_transfer');
        $this->model['stock_transfer_detail'] = $this->load->model('inventory/stock_transfer_detail');
        $this->model['document'] = $this->load->model('common/document');
        $this->model['product'] = $this->load->model('inventory/product');
        $this->model['ledger'] = $this->load->model('gl/ledger');
        $this->model['stock_ledger'] = $this->load->model('common/stock_ledger');

        $this->model['stock_transfer']->edit($this->getAlias(), $primary_key, $data);
        $this->model['stock_transfer_detail']->deleteBulk($this->getAlias(), array('stock_transfer_id' => $stock_transfer_id));
        $this->model['document']->deleteBulk($this->getAlias(), array('document_id' => $stock_transfer_id));
        $this->model['ledger']->deleteBulk($this->getAlias(), array('document_id' => $stock_transfer_id));
        $this->model['stock_ledger']->deleteBulk($this->getAlias(), array('document_id' => $stock_transfer_id));

        $insert_document = array(
            'company_id' => $this->session->data['company_id'],
            'company_branch_id' => $this->session->data['company_branch_id'],
            'fiscal_year_id' => $this->session->data['fiscal_year_id'],
            'document_type_id' => $this->document_type_id,
            'document_id' => $data['document_id'],
            'document_identity' => $data['document_identity'],
            'document_date' => $data['document_date'],
            'partner_type_id' => $data['partner_type_id'],
            'partner_id' => $data['partner_id'],
            'document_currency_id' => $data['document_currency_id'],
            'document_amount' => $data['total_amount'],
            'conversion_rate' => $data['conversion_rate'],
            'base_currency_id' => $data['base_currency_id'],
            'base_amount' => $data['base_amount'],
        );
        $document_id = $this->model['document']->add($this->getAlias(), $insert_document);
        //d(array($document_id, $document), true);
        $stock_ledger = array();
        foreach ($data['stock_transfer_details'] as $sort_order => $detail) {
            $detail['stock_transfer_id'] = $stock_transfer_id;
            $detail['fiscal_year_id'] = $this->session->data['fiscal_year_id'];
            $detail['company_branch_id'] = $this->session->data['company_branch_id'];
            $detail['company_id'] = $this->session->data['company_id'];
            $detail['sort_order'] = $sort_order;
            $detail['document_currency_id'] = $data['document_currency_id'];
            $detail['base_currency_id'] = $data['base_currency_id'];
            $detail['conversion_rate'] = $data['conversion_rate'];
            $detail['base_cog_rate'] = ($detail['cog_rate'] * $data['conversion_rate']);
            $detail['base_cog_amount'] = ($detail['cog_amount'] * $data['conversion_rate']);
            $stock_transfer_detail_id=$this->model['stock_transfer_detail']->add($this->getAlias(), $detail);

            $stock_ledger[] = array(
                'document_detail_id' => $stock_transfer_detail_id,
                'warehouse_id' => $data['warehouse_id'],
                'manual_ref_no' => $detail['manual_ref_no'],
                'container_no' => $detail['container_no'],
                'batch_no' => $detail['batch_no'],
                'product_id' => $detail['product_id'],
                'document_unit_id' => $detail['unit_id'],
                'document_qty' => $detail['qty'],
                'unit_conversion' => 1,
                'base_unit_id' => $detail['unit_id'],
                'base_qty' => (-1 * $detail['qty']),
                'base_cubic_meter' => (-1 * $detail['total_cubic_meter']),
                'base_cubic_feet' => (-1 * $detail['total_cubic_feet']),
                'document_rate' => $detail['cog_rate'],
                'document_amount' => (-1 * $detail['cog_amount']),
                'base_rate' => ($detail['cog_rate'] * $detail['conversion_rate']),
                'base_amount' => (-1 * $detail['cog_amount'] * $detail['conversion_rate']),
                'remarks' => $data['remarks'],
            );
            $stock_ledger[] = array(
                'document_detail_id' => $stock_transfer_detail_id,
                'warehouse_id' => $detail['warehouse_id'],
                'manual_ref_no' => $detail['manual_ref_no'],
                'container_no' => $detail['container_no'],
                'batch_no' => $detail['batch_no'],
                'product_id' => $detail['product_id'],
                'document_unit_id' => $detail['unit_id'],
                'document_qty' => $detail['qty'],
                'unit_conversion' => 1,
                'base_unit_id' => $detail['unit_id'],
                'base_qty' => ($detail['qty']),
                'base_cubic_meter' => $detail['total_cubic_meter'],
                'base_cubic_feet' => $detail['total_cubic_feet'],
                'document_rate' => $detail['cog_rate'],
                'document_amount' => ($detail['cog_amount']),
                'base_rate' => ($detail['cog_rate'] * $detail['conversion_rate']),
                'base_amount' => ($detail['cog_amount'] * $detail['conversion_rate']),
                'remarks' => $data['remarks'],
            );
        }

        //d($stock_ledger, true);
        foreach($stock_ledger as $sort_order => $ledger) {
            $ledger['company_id'] = $this->session->data['company_id'];
            $ledger['company_branch_id'] = $this->session->data['company_branch_id'];
            $ledger['fiscal_year_id'] = $this->session->data['fiscal_year_id'];
            $ledger['document_type_id'] = $this->document_type_id;
            $ledger['document_id'] = $data['document_id'];
            $ledger['document_identity'] = $data['document_identity'];
            $ledger['document_date'] = $data['document_date'];
            $ledger['sort_order'] = $sort_order;
            $ledger['base_currency_id'] = $data['base_currency_id'];
            $ledger['document_currency_id'] = $data['document_currency_id'];
            $ledger['currency_conversion'] = $data['conversion_rate'];

            $stock_ledger_id = $this->model['stock_ledger']->add($this->getAlias(), $ledger);
            //d(array($stock_ledger_id, $ledger), true);
        }

        return $stock_transfer_id;
    }

    protected function updateRedirect($id, $data) {
        $url = $this->getURL();
        $this->redirect($this->url->link($this->getAlias().'/update', 'token=' . $this->session->data['token'] . '&stock_transfer_id=' . $id, 'SSL'));
    }

    protected function validateDelete() {
        if (!$this->user->hasPermission('delete', $this->getAlias())) {
            $this->error['warning'] = $this->language->get('error_permission_delete');
        }

        if (!$this->error) {
            return true;
        } else {
            return false;
        }
    }

    protected function deleteData($primary_key) {
        $this->model['stock_transfer_detail'] = $this->load->model('inventory/stock_transfer_detail');
        $this->model['stock_transfer_detail']->deleteBulk($this->getAlias(),array('stock_transfer_id' => $primary_key));

        $this->model['ledger'] = $this->load->model('gl/ledger');
        $this->model['ledger']->deleteBulk($this->getAlias(), array('document_type_id' => $this->document_type_id, 'document_id' => $primary_key));

        $this->model['document'] = $this->load->model('common/document');
        $this->model['document']->deleteBulk($this->getAlias(), array('document_type_id' => $this->document_type_id, 'document_id' => $primary_key));

        $this->model['stock_ledger'] = $this->load->model('common/stock_ledger');
        $this->model['stock_ledger']->deleteBulk($this->getAlias(), array('document_type_id' => $this->document_type_id, 'document_id' => $primary_key));

        $this->model[$this->getAlias()]->delete($this->getAlias(), $primary_key);
    }

    public function ajaxValidateForm() {
        $post  = $this->request->post;
        $lang = $this->load->language('inventory/stock_transfer');
        $error = array();

        if($post['voucher_date'] == '') {
            $error[] = $lang['error_voucher_date'];
        }

        if($post['supplier_id'] == '') {
            $error[] = $lang['error_supplier'];
        }

        $details = $post['stock_transfer_details'];
        if(empty($details)) {
            $error[] = $lang['error_input_detail'];
        } else {
            $row_no = 0;
            foreach($details as $detail) {
                $row_no++;
                if($detail['product_code'] == '') {
                    $error[] = $lang['error_product_code'] . ' for Row ' . $row_no;
                }
                if($detail['product_id'] == '') {
                    $error[] = $lang['error_product'] . ' for Row ' . $row_no;
                }
                if($detail['warehouse_id'] == '') {
                    $error[] = $lang['error_warehouse'] . ' for Row ' . $row_no;
                }
                if($detail['qty'] == '') {
                    $error[] = $lang['error_qty'] . ' for Row ' . $row_no;
                }
                if($detail['unit_id'] == '') {
                    $error[] = $lang['error_unit'] . ' for Row ' . $row_no;
                }
                if($detail['rate'] == '') {
                    $error[] = $lang['error_rate'] . ' for Row ' . $row_no;
                }
                if($detail['amount'] == '') {
                    $error[] = $lang['error_amount'] . ' for Row ' . $row_no;
                }
                if($detail['qty'] > ($detail['order_qty']-$detail['received_qty'])) {
                    $error[] = $lang['error_qty'] . ' for Row ' . $row_no;
                }
            }
        }

        if (!$error) {
            $json = array(
                'success' => true
            );
        } else {
            $json = array(
                'success' => false,
                'error' => implode("\r\n",$error),
                'errors' => $error,
                'post' => $post
            );
        }

        echo json_encode($json);
        exit;
    }

//    public function printDocument() {
//        $company_id = $this->session->data['company_id'];
//        $company_branch_id = $this->session->data['company_branch_id'];
//        $fiscal_year_id = $this->session->data['fiscal_year_id'];
//
//        $stock_transfer_id = $this->request->get['stock_transfer_id'];
//        $this->data['lang'] = $this->load->language($this->getAlias());
//
//        $this->model['image'] = $this->load->model('tool/image');
//        $this->model['company'] = $this->load->model('setup/company');
//        $this->model['company_branch'] = $this->load->model('setup/company_branch');
//
//        $company = $this->model['company']->getRow(array('company_id' => $company_id));
//        $this->data['company'] = $company;
//        if ($company['company_logo'] && file_exists(DIR_IMAGE . $company['company_logo'])) {
//            $company_logo = $this->model['image']->resize($company['company_logo'], 75, 75);
//        } else {
//            $company_logo = "";
//        }
//        $this->data['company_logo'] = $company_logo;
//        $this->data['company_branch'] = $this->model['company_branch']->getRow(array('company_id' => $company_id, 'company_branch_id' => $company_branch_id));
//
//        $this->model['stock_transfer'] = $this->load->model('inventory/stock_transfer');
//        $row = $this->model['stock_transfer']->getRow(array('stock_transfer_id' => $stock_transfer_id));
//
//        $this->model['partner'] = $this->load->model('common/partner');
//        $partner = $this->model['partner']->getRow(array('company_id' => $company_id, 'company_branch_id' => $company_branch_id, 'partner_type_id' => $row['partner_type_id'], 'partner_id' => $row['partner_id']));
//        //d($partner, true);
//
//        $this->data['document_date'] = $row['document_date'];
//        $this->data['document_no'] = $row['document_identity'];
//        $this->data['partner_name'] = $partner['name'];
//        $this->data['phone_no'] = $partner['phone'];
//        $this->data['address'] = $partner['address'];
//
//        $this->model['stock_transfer_detail'] = $this->load->model('inventory/stock_transfer_detail');
//        $details = $this->model['stock_transfer_detail']->getRows(array('stock_transfer_id' => $stock_transfer_id));
//        foreach($details as $row_no => $detail) {
//            $this->data['details'][$row_no] = $detail;
//        }
//        //d($row,$detail,true);
//        $this->template = 'inventory/stock_transfer_print.tpl';
//        $contents = $this->render();
//
//        try
//        {
//            // init HTML2PDF
//            $html2pdf = new HTML2PDF('L', 'A5', 'en', true, 'UTF-8', array(0, 0, 0, 0));
//
//            // display the full page
//            $html2pdf->pdf->SetDisplayMode('fullpage');
//
//            // convert
//            $html2pdf->writeHTML($contents);
//
//            // send the PDF
//            $html2pdf->Output('Purchase Invoice.pdf');
//        } catch(HTML2PDF_exception $e) {
//            echo $e;
//            exit;
//        }
//    }

    public function printDocument() {
        ini_set('max_execution_time',0);
        ini_set('memory_limit',-1);

        $lang = $this->load->language($this->getAlias());
        $stock_transfer_id = $this->request->get['stock_transfer_id'];
        $post = $this->request->post;
        $session = $this->session->data;

        $this->model['stock_transfer'] = $this->load->model('inventory/stock_transfer');
        $this->model['stock_transfer_detail'] = $this->load->model('inventory/stock_transfer_detail');


        $stock_transfer = $this->model['stock_transfer']->getRow(array('stock_transfer_id' => $stock_transfer_id));
        $stock_transfer_details = $this->model['stock_transfer_detail']->getRows(array('stock_transfer_id' => $stock_transfer_id),array('sort_order asc'));
//        d(array($stock_transfer, $stock_transfer_details), true);

        $pdf = new PDF('P', PDF_UNIT, 'A4', true, 'UTF-8', false);

        // set document information
        $pdf->SetCreator(PDF_CREATOR);
        $pdf->SetAuthor('S.P Zakir');
        $pdf->SetTitle('Stock Transfer');
        $pdf->SetSubject('Stock Transfer');

        //Set Header
        $pdf->data = array(
            'company_name' => $session['company_name'] ,
            'report_name' => 'Stock Transfer',
            'company_logo' => $session['company_image'],
            'status' => 'Print',
        );

        // set margins
        //$pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
        $pdf->SetMargins(2, 10, 2);
        $pdf->SetHeaderMargin(2);
        $pdf->SetFooterMargin(2);

        // set auto page breaks
        //$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);

        // set font
        $pdf->SetFont('times', 'B', 10);

        // add a page
        $pdf->AddPage();

        $pdf->SetFont('times', 'B', 25);
        $pdf->SetTextColor(0, 0, 0);
        $pdf->MultiCell(200, 5, $pdf->data['company_name'], 0, 'C', 0, 0, '', '', true);
        $pdf->Ln(15);
        $pdf->SetFont('times', 'B', 15);
        $pdf->MultiCell(200, 5, $pdf->data['report_name'], 0, 'C', 0, 0, '', '', true);

        $pdf->SetTextColor(0,0,0);
        $pdf->SetFont('times', '', 10);
        $pdf->Ln(15);
        $pdf->Cell(25,6, 'Document No. : ', 0, false, 'L', 0, '', 0, false, 'M', 'M');
        $pdf->Cell(64,6, $stock_transfer['document_identity'], 'B', false, 'L', 0, '', 0, false, 'M', 'M');
        $pdf->Cell(29,6, 'From Warehouse : ', 0, false, 'L', 0, '', 0, false, 'M', 'M');
        $pdf->Cell(70,6, $stock_transfer['warehouse'], 'B', false, 'L', 0, '', 0, false, 'M', 'M');

        $pdf->Ln(7);
        $pdf->Cell(18,6, 'Remarks : ',0, false, 'L', 0, '', 0, false, 'M', 'M');
        $pdf->Cell(189,6, $stock_transfer['remarks'], 'B', false, 'L', 0, '', 0, false, 'M', 'M');

        $pdf->Ln(10);
        $pdf->SetFont('times', 'B', 8);
        $pdf->Cell(25, 8, 'To Warehouse', 1, false, 'C', 0, '', 0, false, 'M', 'M');
        $pdf->Cell(22, 8, 'Container No', 1, false, 'C', 0, '', 0, false, 'M', 'M');
        $pdf->Cell(18, 8, 'Product Code', 1, false, 'C', 0, '', 0, false, 'M', 'M');
        $pdf->Cell(48, 8, 'Product Name', 1, false, 'C', 0, '', 0, false, 'M', 'M');
        $pdf->Cell(10, 8, 'Qty', 1, false, 'C', 0, '', 0, false, 'M', 'M');
        $pdf->Cell(20, 8, 'Cubic Meter', 1, false, 'C', 0, '', 0, false, 'M', 'M');
        $pdf->Cell(20, 8, 'Cubic Feet', 1, false, 'C', 0, '', 0, false, 'M', 'M');
        $pdf->Cell(20, 8, 'Rate', 1, false, 'C', 0, '', 0, false, 'M', 'M');
        $pdf->Cell(24, 8, 'Amount', 1, false, 'C', 0, '', 0, false, 'M', 'M');
//        $pdf->Cell(15, 8, 'Rate', 1, false, 'C', 0, '', 0, false, 'M', 'M');
//        $pdf->Cell(18, 8, 'Amount', 1, false, 'C', 0, '', 0, false, 'M', 'M');
        $sr = 0;
        $pdf->Ln(0);

        $pdf->SetFont('times', '', 8);
        foreach($stock_transfer_details as $detail) {


            $sr++;
            $pdf->Ln(4);
            $pdf->MultiCell(25, 8, $detail['warehouse'], 'LR', 'C', 0, 0, '', '', true);
            $pdf->MultiCell(22, 8, $detail['container_no'], 'LR', 'C', 0, 0, '', '', true);
            $pdf->MultiCell(18, 8, $detail['product_code'], 'LR', 'C', 0, 0, '', '', true);
            $pdf->MultiCell(48, 8, $detail['product_name'], 'LR', 'L', 0, 0, '', '', true);
            $pdf->MultiCell(10, 8, number_format($detail['qty'], 2), 'LR', 'C', 0, 0, '', '', true);
            $pdf->MultiCell(20, 8, number_format($detail['total_cubic_meter'], 4), 'LR', 'C', 0, 0, '', '', true);
            $pdf->MultiCell(20, 8, number_format($detail['total_cubic_feet'], 4), 'LR', 'C', 0, 0, '', '', true);
            $pdf->MultiCell(20, 8, number_format($detail['cog_rate'], 4), 'LR', 'C', 0, 0, '', '', true);
            $pdf->MultiCell(24, 8, number_format($detail['cog_amount'], 4), 'LR', 'C', 0, 0, '', '', true);
        }
        $pdf->SetFont('times', '', 9);
        $x = $pdf->GetX();
        $y = $pdf->GetY();

        for ($i = $y; $i <= 220; $i++) {
            $pdf->Ln(1);
            $pdf->Cell(25, 7, '', 'L',  false, 'C', 0, '', 0, false, 'M', 'M');
            $pdf->Cell(22, 7,'', 'L', false, 'L', 0, '', 0, false, 'M', 'M');
            $pdf->Cell(18, 7,'', 'L', false, 'L', 0, '', 0, false, 'M', 'M');
            $pdf->Cell(48, 7,'', 'L', false, 'L', 0, '', 0, false, 'M', 'M');
            $pdf->Cell(10, 7,'', 'L', false, 'L', 0, '', 0, false, 'M', 'M');
            $pdf->Cell(20, 7,'', 'L', false, 'L', 0, '', 0, false, 'M', 'M');
            $pdf->Cell(20, 7,'', 'L', false, 'L', 0, '', 0, false, 'M', 'M');
            $pdf->Cell(20, 7,'', 'L', false, 'L', 0, '', 0, false, 'M', 'M');
            $pdf->Cell(24, 7, '', 'L,R', false, 'L', 0, '', 0, false, 'M', 'M');
            $y =$i;
        }
        $pdf->Ln(-1);
        $pdf->Ln(1);
        $pdf->Cell(207, 7, '', 'B', false, 'C', 0, '', 0, false, 'M', 'M');
        $pdf->setXY($x,$y);

        $pdf->SetFont('times', 'B', 9);
        $pdf->Ln(50);
        $pdf->Cell(0, 5, 'Signature ----------------------------------', 0, false, 'L', 0, '', 0, false, 'M', 'M');

        $data= $stock_transfer;
        //Close and output PDF document
        $pdf->Output('Stock transfer :'.date('YmdHis').'.pdf', 'I');
    }

}

class PDF extends TCPDF {
    public $data = array();
    public $term = array();


    //Page header
    public function Header() {
        // Logo

        $image_file = DIR_IMAGE . "Logo WBA.png";
        $this->Image($image_file, 170, 8, 32, 10, '', '', 'R', false, 300, '', false, false, 1, false, false, false);

//        if($this->data['company_logo'] != '') {
//            $image_file = DIR_IMAGE.$this->data['company_logo'];
//            //$this->Image($file, $x='', $y='', $w=0, $h=0, $type='', $link='', $align='', $resize=false, $dpi=300, $palign='', $ismask=false, $imgmask=false, $border=0, $fitbox=false, $hidden=false, $fitonpage=false);
//            $this->Image($image_file, 10, 10, 30, '', 'JPG', '', 'T', false, 300, '', false, false, 0, false, false, false);
//        }
//        // Set font
//        $this->SetTextColor(255,255,255);
//        $this->SetFont('times', 'B', 10);
//        $this->Ln(2);
//        // Title
//        $this->Cell(0, 4, $this->data['company_name'], 0, false, 'C', 1, '', 0, false, 'M', 'M');
    }
    // Page footer
    public function Footer() {
//        $this->SetFont('times', 'B', 12);

    }


}

?>