<?php

class ControllerInventoryOpeningStock extends HController {
    protected $document_type_id = 6;

    protected function getAlias() {
        return 'inventory/opening_stock';
    }

    protected function getPrimaryKey() {
        return 'opening_stock_id';
    }

    protected function getList() {
        parent::getList();

        $this->data['action_ajax'] = $this->url->link($this->getAlias() . '/getAjaxLists', 'token=' . $this->session->data['token'], 'SSL');
        $this->response->setOutput($this->render());
    }

    public function getAjaxLists() {

        $lang = $this->load->language('inventory/opening_stock');
        $this->model[$this->getAlias()] = $this->load->model($this->getAlias());
        $data = array();
        $aColumns = array('action','document_date', 'document_identity', 'warehouse', 'remarks', 'created_at','check_box');

        /*
         * Paging
         */
        $sLimit = "";
        if (isset($_GET['iDisplayStart']) && $_GET['iDisplayLength'] != '-1') {
            $data['criteria']['start'] = $_GET['iDisplayStart'];
            $data['criteria']['limit'] = $_GET['iDisplayLength'];
        }

        /*
         * Ordering
         */
        $sOrder = "";
        if (isset($_GET['iSortCol_0'])) {
            $sOrder = " ORDER BY  ";
            for ($i = 0; $i < intval($_GET['iSortingCols']); $i++) {
                if ($_GET['bSortable_' . intval($_GET['iSortCol_' . $i])] == "true") {
                    $sOrder .= "`" . $aColumns[intval($_GET['iSortCol_' . $i])] . "` " .
                        ($_GET['sSortDir_' . $i] === 'asc' ? 'asc' : 'desc') . ", ";
                }
            }

            $sOrder = substr_replace($sOrder, "", -2);
            if ($sOrder == " ORDER BY") {
                $sOrder = "";
            }
            $data['criteria']['orderby'] = $sOrder;
        }


        /*
         * Filtering
         * NOTE this does not match the built-in DataTables filtering which does it
         * word by word on any field. It's possible to do here, but concerned about efficiency
         * on very large tables, and MySQL's regex functionality is very limited
         */
        $arrWhere = array();
        $arrWhere[] = "`company_id` = '".$this->session->data['company_id']."'";
        $arrWhere[] = "`company_branch_id` = '".$this->session->data['company_branch_id']."'";
        if (isset($_GET['sSearch']) && $_GET['sSearch'] != "") {
            $arrSSearch = array();
            for ($i = 0; $i < count($aColumns); $i++) {
                if (isset($_GET['bSearchable_' . $i]) && $_GET['bSearchable_' . $i] == "true" && $_GET['sSearch'] != '') {
                    $arrSSearch[] = "LOWER(`" . $aColumns[$i] . "`) LIKE '%" . $this->db->escape(strtolower($_GET['sSearch'])) . "%'";
                }
            }
            if(!empty($arrSSearch)) {
                $arrWhere[] = '(' . implode(' OR ', $arrSSearch) . ')';
            }
        }

        /* Individual column filtering */
        for ($i = 0; $i < count($aColumns); $i++) {
            if (isset($_GET['bSearchable_' . $i]) && $_GET['bSearchable_' . $i] == "true" && $_GET['sSearch_' . $i] != '') {
                $arrWhere[] = "LOWER(`" . $aColumns[$i] . "`) LIKE '%" . $this->db->escape(strtolower($_GET['sSearch_' . $i])) . "%' ";
            }
        }

        if (!empty($arrWhere)) {
            //$data['filter']['RAW'] = substr($sWhere, 5, strlen($sWhere) - 5);
            $data['filter']['RAW'] = implode(' AND ', $arrWhere);
        }

        //d($data, true);
        $results = $this->model[$this->getAlias()]->getLists($data);
        $iFilteredTotal = $results['total'];
        $iTotal = $results['table_total'];


        /*
         * Output
         */
        $output = array(
            "sEcho" => intval($_GET['sEcho']),
            "iTotalRecords" => $iTotal,
            "iTotalDisplayRecords" => $iFilteredTotal,
            "aaData" => array()
        );

        foreach ($results['lists'] as $aRow) {
            $row = array();
            $actions = array();

            $actions[] = array(
                'text' => $lang['edit'],
                'href' => $this->url->link($this->getAlias() . '/update', 'token=' . $this->session->data['token'] . '&' . $this->getPrimaryKey() . '=' . $aRow[$this->getPrimaryKey()], 'SSL'),
                'btn_class' => 'btn btn-primary btn-xs',
                'class' => 'fa fa-pencil'
            );

            $actions[] = array(
                'text' => $lang['print'],
                'target'=>"_blank",
                'href' => $this->url->link($this->getAlias() . '/printDetailReport', 'token=' . $this->session->data['token'] . '&' . $this->getPrimaryKey() . '=' . $aRow[$this->getPrimaryKey()], 'SSL'),
                'btn_class' => 'btn btn-info btn-xs',
                'class' => 'fa fa-print'
            );

            if($aRow['is_post']==0) {
                $actions[] = array(
                    'text' => $lang['post'],
                    'href' => $this->url->link($this->getAlias() . '/post', 'token=' . $this->session->data['token'] . '&' . $this->getPrimaryKey() . '=' . $aRow[$this->getPrimaryKey()], 'SSL'),
                    'btn_class' => 'btn btn-info btn-xs',
                    'class' => 'fa fa-thumbs-up'
                );

                $actions[] = array(
                    'text' => $lang['delete'],
                    'href' => 'javascript:void(0);',
                    'click' => "ConfirmDelete('" . $this->url->link($this->getAlias() . '/delete', 'token=' . $this->session->data['token'] . '&id=' . $aRow[$this->getPrimaryKey()], 'SSL') . "')",
                    'btn_class' => 'btn btn-danger btn-xs',
                    'class' => 'fa fa-times'
                );
            }

            $strAction = '';
            foreach ($actions as $action) {
                $strAction .= '<a '.(isset($action['btn_class'])?'class="'.$action['btn_class'].'"':'').' '.(isset($action['target'])?'target="'.$action['target'].'"':'').' href="' . $action['href'] . '" data-toggle="tooltip" title="' . $action['text'] . '" ' . (isset($action['click']) ? 'onClick="' . $action['click'] . '"' : '') . '>';
                if (isset($action['class'])) {
                    $strAction .= '<span class="' . $action['class'] . '"></span>';
                } else {
                    $strAction .= $action['text'];
                }
                $strAction .= '</a>&nbsp;';
            }

            for ($i = 0; $i < count($aColumns); $i++) {
                if ($aColumns[$i] == 'action') {
                    $row[] = $strAction;
                } elseif ($aColumns[$i] == 'created_at') {
                    $row[] = stdDateTime($aRow['created_at']);
                } elseif ($aColumns[$i] == 'document_date') {
                    $row[] = stdDate($aRow['document_date']);
                } elseif ($aColumns[$i] == 'check_box') {
                    if($aRow['is_post']==0) {
                        $row[] = '<input type="checkbox" name="selected[]" value="' . $aRow[$this->getPrimaryKey()] . '" />';
                    } else {
                        $row[] = '';
                    }
                } else {
                    $row[] = $aRow[$aColumns[$i]];
                }

            }
            $output['aaData'][] = $row;
        }

        echo json_encode($output);
    }



    protected function getForm() {
        parent::getForm();

//        $this->model['product'] = $this->load->model('inventory/product');
//        $this->data['products'] = $this->model['product']->getRows(array('company_id' => $this->session->data['company_id']));

        $this->model['currency'] = $this->load->model('setup/currency');
        $this->data['currencys'] = $this->model['currency']->getRows();

        $this->model['unit'] = $this->load->model('inventory/unit');
        $this->data['units'] = $this->model['unit']->getRows(array('company_id' => $this->session->data['company_id']));

        $this->model['warehouse'] = $this->load->model('setup/warehouse');
        $this->data['warehouses'] = $this->model['warehouse']->getRows(array('company_id' => $this->session->data['company_id'], 'company_branch_id' => $this->session->data['company_branch_id']));
        $this->data['arrWarehouses'] = json_encode($this->data['warehouses']);

        $this->data['base_currency_id'] = $this->session->data['base_currency_id'];
        $this->data['base_currency'] = $this->session->data['base_currency_name'];
        $this->data['document_currency_id'] = $this->session->data['base_currency_id'];
        $this->data['conversion_rate'] = "1.00";
        //d($this->data, true);

        $this->data['partner_types'] = $this->session->data['partner_types'];

        $this->data['document_date'] = stdDate();
        if (isset($this->request->get['opening_stock_id']) && ($this->request->server['REQUEST_METHOD'] != 'POST')) {
            $this->data['isEdit'] = 1;
            $result = $this->model[$this->getAlias()]->getRow(array('opening_stock_id' => $this->request->get[$this->getPrimaryKey()]));
            foreach ($result as $field => $value) {
                if ($field == 'document_date') {
                    $this->data[$field] = stdDate($value);
                } else {
                    $this->data[$field] = $value;
                }
            }
            $this->model['opening_stock_detail'] = $this->load->model('inventory/opening_stock_detail');
            $this->data['opening_stock_details'] = $this->model['opening_stock_detail']->getRows(array('opening_stock_id' => $this->request->get['opening_stock_id']), array('sort_order'));
        }

        $this->data['href_get_product_json'] = $this->url->link($this->getAlias() . '/getProductJson', 'token=' . $this->session->data['token'] . '&' . $this->getPrimaryKey() . '=' . $this->request->get[$this->getPrimaryKey()], 'SSL');
        $this->data['href_get_product_by_code'] = $this->url->link('common/function/getProductByCode', 'token=' . $this->session->data['token']);
        $this->data['href_get_product_by_id'] = $this->url->link('common/function/getProductById', 'token=' . $this->session->data['token']);
        $this->data['action_validate_date'] = $this->url->link('common/function/validateDate', 'token=' . $this->session->data['token']);
        $this->data['href_print_detail_report'] = $this->url->link($this->getAlias() .'/printDetailReport', 'token=' . $this->session->data['token']. '&' . $this->getPrimaryKey() . '=' . $this->request->get[$this->getPrimaryKey()], 'SSL');
        $this->data['strValidation']= "{
            'rules':{
                'document_date': {'required':true, 'remote':  {url: '" . $this->data['action_validate_date'] . "', type: 'post'}},
                'warehouse_id': {'required':true},
                'conversion_rate': {'required':true},
            },
            'ignore': []
          }";


        $this->response->setOutput($this->render());
    }

    public function printReport(){
        ini_set('max_execution_time',0);
        ini_set('memory_limit',-1);

        //d(array('session' => $this->session->data, 'post' => $this->request->post, 'get' => $this->request->get), true);
        $lang = $this->load->language($this->getAlias());
        $post = $this->request->post;
        $session = $this->session->data;
        $opening_stock_id = $this->request->get['opening_stock_id'];
        //d($opening_stock_id,true);

        $this->model['opening_stock_detail'] = $this->load->model('inventory/opening_stock_detail');
        $rows = $this->model['opening_stock_detail']->getRow(array('opening_stock_id'=>$opening_stock_id));

        $this->model['opening_stock'] = $this->load->model('inventory/opening_stock');
        $row = $this->model['opening_stock']->getRow(array('opening_stock_id'=>$opening_stock_id));
        //d($rows['document_identity'],true);

        $pdf = new PDF('P', PDF_UNIT, 'A4', true, 'UTF-8', false);

        // set document information
        $pdf->SetCreator(PDF_CREATOR);
        $pdf->SetAuthor('Huzaifa Khambaty');
        $pdf->SetTitle('Opening Stock');
        $pdf->SetSubject('Opening Stock');

        //Set Header
        $pdf->data = array(
            'company_name' => $session['company_name'],
            'report_name' => $lang['heading_title'],
            'company_logo' => $session['company_image']
        );

        // set margins
        //$pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
        $pdf->SetMargins(15, 35, 5);
        $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
        $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);

        // set auto page breaks
        $pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);

        // set font
        //$pdf->SetFont('times', 'B', 8);

        // add a page
        $pdf->AddPage();

        $pdf->SetFont('times', 'B', 9);
        $pdf->Cell(30, 7, 'Document No: ', 0, false, 'L', 0, '', 0, false, 'M', 'M');
        // set font
        $pdf->SetFont('times', '', 9);
        $pdf->Cell(70, 7, $row['document_identity'], 'B', false, 'L', 0, '', 0, false, 'M', 'M');
        //set font
        $pdf->SetFont('times', 'B', 9);
        $pdf->Cell(30, 7, 'Date: ', 0, false, 'R', 0, '', 0, false, 'M', 'M');
        //set font
        $pdf->SetFont('times', '', 9);
        $pdf->Cell(50, 7, stdDate($rows['date']), 'B', false, 'L', 0, '', 0, false, 'M', 'M');
        $pdf->ln(10);
        // set font
        $pdf->SetFont('times', 'B', 9);
        $pdf->Cell(30, 7, 'Remarks:', 0, false, 'L', 0, '', 0, false, 'M', 'M');
        // set font
        $pdf->SetFont('times', '', 9);
        $pdf->Cell(150, 7, $row['remarks'], 'B', false, 'L', 0, '', 0, false, 'M', 'M');
        $pdf->ln(10);

        // set font
        $pdf->SetFont('times', 'B', 9);
        $pdf->Cell(30, 7, 'Warehouse: ', 0, false, 'L', 0, '', 0, false, 'M', 'M');
        // set font
        $pdf->SetFont('times', '', 9);
        $pdf->Cell(150, 7, $row['warehouse'], 'B', false, 'L', 0, '', 0, false, 'M', 'M');

        // set font
        $pdf->SetFont('times', 'B', 9);
        $pdf->Cell(20, 7, '', 0, false, 'R', 0, '', 0, false, 'M', 'M');
        //set font
        $pdf->SetFont('times', '', 9);
        $pdf->Cell(40, 7, '', 0, false, 'L', 0, '', 0, false, 'M', 'M');
        $pdf->ln(10);

        $pdf->SetFont('times', '', 8);
        $pdf->SetFillColor(215, 215, 215);
        $pdf->SetTextColor(0, 0, 0);

        $pdf->Cell(80, 10, $lang['product'], 1, false, 'C', 1, '', 1);
        $pdf->Cell(23, 10, $lang['container_no'], 1, false, 'C', 1, '', 1 );
        $pdf->Cell(16, 10, $lang['quantity'], 1, false, 'C', 1, '', 1);
        $pdf->Cell(17, 10, $lang['cubic_meter'], 1, false, 'C', 1, '', 1);
        $pdf->Cell(17, 10, $lang['cubic_feet'], 1, false, 'C', 1, '', 1);
        $pdf->Cell(14, 10, $lang['rate'], 1, false, 'C', 1, '', 1);
        $pdf->Cell(20, 10, $lang['amount'], 1, false, 'C', 1, '', 1);
        $pdf->Ln(7);

        $pdf->SetFillColor(255, 255, 255);
        $pdf->SetTextColor(0, 0, 0);

        $pdf->Ln(6);

        //$pdf->Cell(20, 7, $detail['warehouse'], 1, false, 'L', 0, '', 1, false, 'M', 'M');
        $pdf->Cell(80, 7, $rows['product'], 1, false, 'L', 0, '', 1, false, 'M', 'M');
        $pdf->Cell(23, 7, $rows['container_no'], 1, false, 'L', 0, '', 1, false, 'M', 'M');
        $pdf->Cell(16, 7, $rows['qty'], 1, false, 'L', 0, '', 1, false, 'M', 'M');
        $pdf->Cell(17, 7, $rows['cubic_meter'],1, false, 'R', '0', 0, '1', false, 'M', 'M');
        $pdf->Cell(17, 7, $rows['cubic_feet'],1, false, 'R', '0', 0, '1', false, 'M', 'M');
        $pdf->Cell(14, 7, number_format($rows['rate'],2), 1, false, 'R', 0, '', 1, false, 'M', 'M');
        $pdf->Cell(20, 7, number_format($rows['amount'],2), 1, false, 'R', 0, '', 1, false, 'M', 'M');

        $pdf->ln(4);
        $pdf->Cell(187, 8, '', 1, false, 'L', 0, '', 1);

        $pdf->ln(8);
        $pdf->Cell(137, 6, '', 0, false, 'L');
        $pdf->Cell(25, 6, $lang['net_amount'].': ', 'LT', false, 'L');
        $pdf->Cell(25, 6, number_format($rows['amount'],2), 'RT', false, 'R');

        $pdf->ln(6);
        $pdf->Cell(137, 6, '', 0, false, 'L');
        $pdf->Cell(25, 6, 'Total Cubic Meter: ', 'LT', false, 'L');
        $pdf->Cell(25, 6, number_format($rows['cubic_meter'],5), 'RTB', false, 'R');

        $pdf->ln(6);
        $pdf->Cell(137, 6, 'IN WORD: ' . Number2Words(round($rows['amount'],2)). ' only', 0, false, 'L');
        $pdf->Cell(25, 6, 'Total Cubic Feet: ', 'LTB', false, 'L');
        $pdf->Cell(25, 6, number_format($rows['cubic_feet'],5), 'RB', false, 'R');



        //Close and output PDF document
        $pdf->Output('Opening Stock:'.date('YmdHis').'.pdf', 'I');

    }

    public function printDetailReport() {
        ini_set('max_execution_time',0);
        ini_set('memory_limit',-1);

        //d(array('session' => $this->session->data, 'post' => $this->request->post, 'get' => $this->request->get), true);
        $lang = $this->load->language($this->getAlias());
        $post = $this->request->post;
        $session = $this->session->data;
        $opening_stock_id = $this->request->get['opening_stock_id'];
        //d($opening_stock_id,true);

        //$invoice = $this->model['purchase_invoice']->getRow(array('purchase_invoice_id' => $purchase_invoice_id));

        $this->model['opening_stock_detail'] = $this->load->model('inventory/opening_stock_detail');
        $rows = $this->model['opening_stock_detail']->getRows(array('opening_stock_id'=>$opening_stock_id));

        $this->model['opening_stock'] = $this->load->model('inventory/opening_stock');
        $row = $this->model['opening_stock']->getRow(array('opening_stock_id'=>$opening_stock_id));
        //d($row['document_identity'],true);

//        $this->model['opening_stock_detail'] = $this->load->model('inventory/opening_stock_detail');
//        $rowsec = $this->model['opening_stock_detail']->getRows(array('opening_stock_id'=>$opening_stock_id),array('container_no','product'));
        //d($rowsec,true);
        //d($rows, true);
        $pdf = new PDF('P', PDF_UNIT, 'A4', true, 'UTF-8', false);

        // set document information
        $pdf->SetCreator(PDF_CREATOR);
        $pdf->SetAuthor('Huzaifa Khambaty');
        $pdf->SetTitle('Opening Stock');
        $pdf->SetSubject('Opening Stock');

        //Set Header
        $pdf->data = array(
            'company_name' => $session['company_name'],
            'report_name' => $lang['heading_title'],
            'company_logo' => $session['company_image']
        );

        // set margins
        //$pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
        $pdf->SetMargins(15, 35, 5);
        $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
        $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);

        // set auto page breaks
        $pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);

        // set font
        //$pdf->SetFont('times', 'B', 8);

        // add a page
        $pdf->AddPage();

        $pdf->SetFont('times', 'B', 9);
        $pdf->Cell(30, 7, 'Document No: ', 0, false, 'L', 0, '', 0, false, 'M', 'M');
        // set font
        $pdf->SetFont('times', '', 9);
        $pdf->Cell(70, 7, $row['document_identity'], 'B', false, 'L', 0, '', 0, false, 'M', 'M');
        //set font
        $pdf->SetFont('times', 'B', 9);
        $pdf->Cell(30, 7, 'Date: ', 0, false, 'R', 0, '', 0, false, 'M', 'M');
        //set font
        $pdf->SetFont('times', '', 9);
        $pdf->Cell(50, 7, stdDate($rows['date']), 'B', false, 'L', 0, '', 0, false, 'M', 'M');
        $pdf->ln(10);
        // set font
        $pdf->SetFont('times', 'B', 9);
        $pdf->Cell(30, 7, 'Remarks:', 0, false, 'L', 0, '', 0, false, 'M', 'M');
        // set font
        $pdf->SetFont('times', '', 9);
        $pdf->Cell(150, 7, $row['remarks'], 'B', false, 'L', 0, '', 0, false, 'M', 'M');
        $pdf->ln(10);

        // set font
        $pdf->SetFont('times', 'B', 9);
        $pdf->Cell(30, 7, 'Warehouse: ', 0, false, 'L', 0, '', 0, false, 'M', 'M');
        // set font
        $pdf->SetFont('times', '', 9);
        $pdf->Cell(150, 7, $row['warehouse'], 'B', false, 'L', 0, '', 0, false, 'M', 'M');

        // set font
        $pdf->SetFont('times', 'B', 9);
        $pdf->Cell(20, 7, '', 0, false, 'R', 0, '', 0, false, 'M', 'M');
         //set font
        $pdf->SetFont('times', '', 9);
        $pdf->Cell(40, 7, '', 0, false, 'L', 0, '', 0, false, 'M', 'M');
        $pdf->ln(10);

        $pdf->SetFont('times', '', 8);
        $pdf->SetFillColor(215, 215, 215);
        $pdf->SetTextColor(0, 0, 0);

        $pdf->Cell(80, 10, $lang['product'], 1, false, 'C', 1, '', 1);
        $pdf->Cell(23, 10, $lang['container_no'], 1, false, 'C', 1, '', 1 );
        $pdf->Cell(16, 10, $lang['quantity'], 1, false, 'C', 1, '', 1);
        $pdf->Cell(17, 10, $lang['cubic_meter'], 1, false, 'C', 1, '', 1);
        $pdf->Cell(17, 10, $lang['cubic_feet'], 1, false, 'C', 1, '', 1);
        $pdf->Cell(14, 10, $lang['rate'], 1, false, 'C', 1, '', 1);
        $pdf->Cell(20, 10, $lang['amount'], 1, false, 'C', 1, '', 1);
        $pdf->Ln(7);
        $sr = 0;

        $pdf->SetFillColor(255, 255, 255);
        $pdf->SetTextColor(0, 0, 0);
        $total_qty = 0;
        $total_meter = 0;
        $total_feet = 0;
        $total_amount = 0;
        foreach($rows as $detail) {
            $sr++;
            $pdf->ln(7);

            //$pdf->Cell(20, 7, $detail['warehouse'], 1, false, 'L', 0, '', 1, false, 'M', 'M');
            $pdf->Cell(80, 7, $detail['product'], 1, false, 'L', 0, '', 1, false, 'M', 'M');
            $pdf->Cell(23, 7, $detail['container_no'], 1, false, 'L', 0, '', 1, false, 'M', 'M');
            $pdf->Cell(16, 7, $detail['qty'], 1, false, 'L', 0, '', 1, false, 'M', 'M');
            $pdf->Cell(17, 7, $detail['total_cubic_meter'],1, false, 'R', '0', 0, '1', false, 'M', 'M');
            $pdf->Cell(17, 7, $detail['total_cubic_feet'],1, false, 'R', '0', 0, '1', false, 'M', 'M');
            $pdf->Cell(14, 7, number_format($detail['rate'],2), 1, false, 'R', 0, '', 1, false, 'M', 'M');
            $pdf->Cell(20, 7, number_format($detail['amount'],2), 1, false, 'R', 0, '', 1, false, 'M', 'M');

            $total_qty += $detail['qty'];
            $total_meter += $detail['total_cubic_meter'];
            $total_feet += $detail['total_cubic_feet'];
            $total_amount += $detail['amount'];
        }
        $pdf->ln(4);
        $pdf->Cell(187, 8, '', 1, false, 'L', 0, '', 1);
        $pdf->ln(8);

        $x = $pdf->GetX();
        $y = $pdf->GetY();

        $pdf->Cell(137, 6, '', 0, false, 'L');
        $pdf->Cell(25, 6, $lang['total_qty'].': ', 'LT', false, 'L');
        $pdf->Cell(25, 6, number_format($total_qty,0), 'RT', false, 'R');
        $pdf->ln(6);

        $pdf->Cell(137, 6, '', 0, false, 'L');
        $pdf->Cell(25, 6, 'Total Cubic Meter: ', 'LT', false, 'L');
        $pdf->Cell(25, 6, number_format($total_meter,2), 'RTB', false, 'R');
        $pdf->ln(6);

        $pdf->Cell(137, 6, '', 0, false, 'L');
        $pdf->Cell(25, 6, 'Total Cubic Feet: ', 'LTB', false, 'L');
        $pdf->Cell(25, 6, number_format($total_feet,2), 'RB', false, 'R');
        $pdf->ln(6);

        $pdf->Cell(137, 6, '', 0, false, 'L');
        $pdf->Cell(25, 6, $lang['net_amount'].': ', 'LTB', false, 'L');
        $pdf->Cell(25, 6, number_format($total_amount,2), 'RTB', false, 'R');
        $pdf->ln(6);

        $x += 10;
        $y += 6;
        $pdf->MultiCell(117, 24, 'IN WORD: ' . Number2Words(round($total_amount,2)). ' only', 0, 'L',false,0,$x,$y);

        //Close and output PDF document
        $pdf->Output('Opening Stock:'.date('YmdHis').'.pdf', 'I');
    }

    protected function insertData($data) {
        $this->model['document_type'] = $this->load->model('common/document_type');
        $document = $this->model['document_type']->getNextDocument($this->document_type_id);

        $data['document_date'] = MySqlDate($data['document_date']);
        $data['company_id'] = $this->session->data['company_id'];
        $data['company_branch_id'] = $this->session->data['company_branch_id'];
        $data['fiscal_year_id'] = $this->session->data['fiscal_year_id'];
        $data['document_type_id'] = $this->document_type_id;
        $data['document_prefix'] = $document['document_prefix'];
        $data['document_no'] = $document['document_no'];
        $data['document_identity'] = $document['document_identity'];
        $data['base_amount'] = $data['net_amount'] * $data['conversion_rate'];
        $opening_stock_id = $this->model[$this->getAlias()]->add($this->getAlias(), $data);
        $data['document_id'] = $opening_stock_id;

        $this->model['opening_stock'] = $this->load->model('inventory/opening_stock');
        $this->model['opening_stock_detail'] = $this->load->model('inventory/opening_stock_detail');
        $this->model['document'] = $this->load->model('common/document');
        $this->model['stock_ledger'] = $this->load->model('common/stock_ledger');
        $this->model['ledger'] = $this->load->model('gl/ledger');
        $this->model['product'] = $this->load->model('inventory/product');
        $this->model['setting'] = $this->load->model('common/setting');

        $row = $this->model['setting']->getRow(array(
            'company_id' => $this->session->data['company_id'],
            //'company_branch_id' => $this->session->data['company_branch_id'],
            //'fiscal_year_id' => $this->session->data['fiscal_year_id'],
            'module' => 'general',
            'field' => 'suspense_account_id',
        ));
        $suspense_account_id = $row['value'];

        $insert_document = array(
            'company_id' => $this->session->data['company_id'],
            'company_branch_id' => $this->session->data['company_branch_id'],
            'fiscal_year_id' => $this->session->data['fiscal_year_id'],
            'document_type_id' => $this->document_type_id,
            'document_id' => $opening_stock_id,
            'document_identity' => $data['document_identity'],
            'document_date' => $data['document_date'],
            'partner_type_id' => '',
            'partner_id' => '',
            'document_currency_id' => $data['document_currency_id'],
            'document_amount' => $data['net_amount'],
            'conversion_rate' => $data['conversion_rate'],
            'base_currency_id' => $data['base_currency_id'],
            'base_amount' => $data['base_amount'],
        );
        $document_id = $this->model['document']->add($this->getAlias(), $insert_document);


        $gl[] = array(
            'partner_type_id' => '',
            'partner_id' => '',
            'reference_document_type_id' => '',
            'reference_document_identity' => '',
            'coa_id' => $suspense_account_id,
            'remarks' => '',
            'document_currency_id' => $data['document_currency_id'],
            'document_debit' => 0,
            'document_credit' => $data['net_amount'],
            'base_currency_id' => $data['base_currency_id'],
            'conversion_rate' => $data['conversion_rate'],
            'debit' => 0,
            'credit' => $data['base_amount'],
        );

        $sort_order = 0;
        foreach ($data['opening_stock_details'] as $detail) {
            $product = $this->model['product']->getRow(array('product_id' => $detail['product_id']));

            $detail['opening_stock_id'] = $opening_stock_id;
            $detail['sort_order'] = $sort_order+1;
            $detail['company_id'] = $this->session->data['company_id'];
            $detail['company_branch_id'] = $this->session->data['company_branch_id'];
            $detail['fiscal_year_id'] = $this->session->data['fiscal_year_id'];
            $detail['document_currency_id'] = $data['document_currency_id'];
            $detail['base_currency_id'] = $data['base_currency_id'];
            $detail['conversion_rate'] = $data['conversion_rate'];
            $detail['base_amount'] = $data['conversion_rate'] * $detail['amount'];
            $opening_stock_detail_id = $this->model['opening_stock_detail']->add($this->getAlias(), $detail);

            $stock_ledger = array(
                'company_id' => $detail['company_id'],
                'company_branch_id' => $detail['company_branch_id'],
                'fiscal_year_id' => $detail['fiscal_year_id'],
                'document_type_id' => $data['document_type_id'],
                'document_id' => $data['document_id'],
                'document_identity' => $data['document_identity'],
                'document_date' => $data['document_date'],
                'document_detail_id' => $opening_stock_detail_id,
                'warehouse_id' => $data['warehouse_id'],
                'manual_ref_no' => $detail['manual_ref_no'],
                'container_no' => $detail['container_no'],
                'batch_no' => $detail['batch_no'],
                'product_id' => $detail['product_id'],
                'document_unit_id' => $detail['unit_id'],
                'document_qty' => $detail['qty'],
                'unit_conversion' => 1,
                'base_unit_id' => $detail['unit_id'],
                'base_qty' => $detail['qty'],
                'base_cubic_meter' => $detail['total_cubic_meter'],
                'base_cubic_feet' => $detail['total_cubic_feet'],
                'document_currency_id' => $detail['document_currency_id'],
                'document_rate' => $detail['rate'],
                'document_amount' => $detail['amount'],
                'currency_conversion' => $detail['conversion_rate'],
                'base_currency_id' => $detail['base_currency_id'],
                'base_rate' => ($detail['rate'] * $detail['conversion_rate']),
                'base_amount' => ($detail['amount'] * $detail['conversion_rate']),
            );
            $stock_ledger_id = $this->model['stock_ledger']->add($this->getAlias(), $stock_ledger);

            $gl[] = array(
                'document_detail_id' => $opening_stock_detail_id,
                'manual_ref_no' => $detail['manual_ref_no'],
                'partner_type_id' => '',
                'partner_id' => '',
                'reference_document_type_id' => $this->document_type_id,
                'reference_document_identity' => $data['document_identity'],
                'coa_id' => $product['inventory_account_id'],
                'remarks' => '',
                'document_currency_id' => $detail['document_currency_id'],
                'document_debit' => $detail['amount'],
                'document_credit' => 0,
                'base_currency_id' => $detail['base_currency_id'],
                'conversion_rate' => $detail['conversion_rate'],
                'debit' => ($detail['amount'] * $detail['conversion_rate']),
                'credit' => 0,
            );
            $sort_order++;
        }

        if($gl) {
            foreach($gl as $sort_order => $ledger) {
                $ledger['company_id'] = $this->session->data['company_id'];
                $ledger['company_branch_id'] = $this->session->data['company_branch_id'];
                $ledger['fiscal_year_id'] = $this->session->data['fiscal_year_id'];
                $ledger['fiscal_year_id'] = $this->session->data['fiscal_year_id'];
                $ledger['document_type_id'] = $this->document_type_id;
                $ledger['document_id'] = $data['document_id'];
                $ledger['document_identity'] = $data['document_identity'];
                $ledger['document_date'] = $data['document_date'];
                $ledger['sort_order'] = $sort_order;

                $ledger_id = $this->model['ledger']->add($this->getAlias(), $ledger);
            }
        }

        return $opening_stock_id;
    }

    protected function updateData($primary_key, $data) {
        $this->model['opening_stock'] = $this->load->model('inventory/opening_stock');
        $this->model['opening_stock_detail'] = $this->load->model('inventory/opening_stock_detail');
        $this->model['document'] = $this->load->model('common/document');
        $this->model['stock_ledger'] = $this->load->model('common/stock_ledger');
        $this->model['ledger'] = $this->load->model('gl/ledger');
        $this->model['product'] = $this->load->model('inventory/product');
        $this->model['setting'] = $this->load->model('common/setting');

        $this->model['document']->deleteBulk($this->getAlias(), array('document_id' => $primary_key));
        $this->model['stock_ledger']->deleteBulk($this->getAlias(), array('document_id' => $primary_key));
        $this->model['opening_stock_detail']->deleteBulk($this->getAlias(), array('opening_stock_id' => $primary_key));
        $this->model['ledger']->deleteBulk($this->getAlias(), array('document_id' => $primary_key));

        $data['document_date'] = MySqlDate($data['document_date']);
        $data['base_amount'] = $data['net_amount'] * $data['conversion_rate'];
        $this->model['opening_stock']->edit($this->getAlias(), $primary_key, $data);
        $opening_stock = $this->model['opening_stock']->getRow(array('opening_stock_id' => $primary_key));

        $row = $this->model['setting']->getRow(array(
            'company_id' => $this->session->data['company_id'],
            'company_branch_id' => $this->session->data['company_branch_id'],
            'fiscal_year_id' => $this->session->data['fiscal_year_id'],
            'module' => 'general',
            'field' => 'suspense_account_id',
        ));
        $suspense_account_id = $row['value'];

        $insert_document = array(
            'company_id' => $this->session->data['company_id'],
            'company_branch_id' => $this->session->data['company_branch_id'],
            'fiscal_year_id' => $this->session->data['fiscal_year_id'],
            'document_type_id' => $this->document_type_id,
            'document_id' => $primary_key,
            'document_identity' => $data['document_identity'],
            'document_date' => $data['document_date'],
            'partner_type_id' => '',
            'partner_id' => '',
            'document_currency_id' => $data['document_currency_id'],
            'document_amount' => $data['net_amount'],
            'conversion_rate' => $data['conversion_rate'],
            'base_currency_id' => $data['base_currency_id'],
            'base_amount' => $data['base_amount'],
            'created_at' => $data['created_at'],
        );
        $document_id = $this->model['document']->add($this->getAlias(), $insert_document);

        $gl[] = array(
            'partner_type_id' => '',
            'partner_id' => '',
            'reference_document_type_id' => '',
            'reference_document_identity' => '',
            'coa_id' => $suspense_account_id,
            'remarks' => '',
            'document_currency_id' => $data['document_currency_id'],
            'document_debit' => 0,
            'document_credit' => $data['net_amount'],
            'base_currency_id' => $data['base_currency_id'],
            'conversion_rate' => $data['conversion_rate'],
            'debit' => 0,
            'credit' => $data['base_amount'],
        );

        foreach ($data['opening_stock_details'] as $sort_order => $detail) {
            $product = $this->model['product']->getRow(array('product_id' => $detail['product_id']));

            $detail['opening_stock_id'] = $primary_key;
            $detail['sort_order'] = $sort_order+1;
            $detail['company_id'] = $this->session->data['company_id'];
            $detail['company_branch_id'] = $this->session->data['company_branch_id'];
            $detail['fiscal_year_id'] = $this->session->data['fiscal_year_id'];
            $detail['document_currency_id'] = $data['document_currency_id'];
            $detail['base_currency_id'] = $data['base_currency_id'];
            $detail['conversion_rate'] = $data['conversion_rate'];
            $detail['base_amount'] = $data['conversion_rate'] * $detail['amount'];
            $detail['created_at'] = $data['created_at'];
            $opening_stock_detail_id = $this->model['opening_stock_detail']->add($this->getAlias(), $detail);

            $stock_ledger = array(
                'company_id' => $detail['company_id'],
                'company_branch_id' => $detail['company_branch_id'],
                'fiscal_year_id' => $detail['fiscal_year_id'],
                'document_type_id' => $data['document_type_id'],
                'document_id' => $data['document_id'],
                'document_identity' => $data['document_identity'],
                'document_date' => $data['document_date'],
                'document_detail_id' => $opening_stock_detail_id,
                'warehouse_id' => $data['warehouse_id'],
                'manual_ref_no' => $detail['manual_ref_no'],
                'container_no' => $detail['container_no'],
                'batch_no' => $detail['batch_no'],
                'product_id' => $detail['product_id'],
                'document_unit_id' => $detail['unit_id'],
                'document_qty' => $detail['qty'],
                'unit_conversion' => 1,
                'base_unit_id' => $detail['unit_id'],
                'base_qty' => $detail['qty'],
                'base_cubic_meter' => $detail['total_cubic_meter'],
                'base_cubic_feet' => $detail['total_cubic_feet'],
                'document_currency_id' => $detail['document_currency_id'],
                'document_rate' => $detail['rate'],
                'document_amount' => $detail['amount'],
                'currency_conversion' => $detail['conversion_rate'],
                'base_currency_id' => $detail['base_currency_id'],
                'base_rate' => ($detail['rate'] * $detail['conversion_rate']),
                'base_amount' => ($detail['amount'] * $detail['conversion_rate']),
                'created_at' => $data['created_at'],
            );
            $stock_ledger_id = $this->model['stock_ledger']->add($this->getAlias(), $stock_ledger);
            //d(array($stock_ledger_id, $stock_ledger),true);

            $gl[] = array(
                'document_detail_id' => $opening_stock_detail_id,
                'manual_ref_no' => $detail['manual_ref_no'],
                'partner_type_id' => '',
                'partner_id' => '',
                'reference_document_type_id' => $this->document_type_id,
                'reference_document_identity' => $data['document_identity'],
                'coa_id' => $product['inventory_account_id'],
                'remarks' => '',
                'document_currency_id' => $detail['document_currency_id'],
                'document_debit' => $detail['amount'],
                'document_credit' => 0,
                'base_currency_id' => $detail['base_currency_id'],
                'conversion_rate' => $detail['conversion_rate'],
                'debit' => ($detail['amount'] * $detail['conversion_rate']),
                'credit' => 0,
            );
        }

        //d(array($data['opening_stock_details'], $gl), true);
        if($gl) {
            foreach($gl as $sort_order => $ledger) {
                $ledger['company_id'] = $this->session->data['company_id'];
                $ledger['company_branch_id'] = $this->session->data['company_branch_id'];
                $ledger['fiscal_year_id'] = $this->session->data['fiscal_year_id'];
                $ledger['fiscal_year_id'] = $this->session->data['fiscal_year_id'];
                $ledger['document_type_id'] = $this->document_type_id;
                $ledger['document_id'] = $data['document_id'];
                $ledger['document_identity'] = $data['document_identity'];
                $ledger['document_date'] = $data['document_date'];
                $ledger['sort_order'] = $sort_order;
                $ledger['created_at'] = $data['created_at'];

                $ledger_id = $this->model['ledger']->add($this->getAlias(), $ledger);
            }
        }

        return $primary_key;
    }

    protected function deleteData($primary_key) {
        $this->model['opening_stock'] = $this->load->model('inventory/opening_stock');
        $this->model['opening_stock_detail'] = $this->load->model('inventory/opening_stock_detail');
        $this->model['document'] = $this->load->model('common/document');
        $this->model['stock_ledger'] = $this->load->model('common/stock_ledger');
        $this->model['ledger'] = $this->load->model('gl/ledger');

        $this->model['ledger']->deleteBulk($this->getAlias(), array('document_id' => $primary_key));
        $this->model['stock_ledger']->deleteBulk($this->getAlias(), array('document_id' => $primary_key));
        $this->model['opening_stock_detail']->deleteBulk($this->getAlias(), array('opening_stock_id' => $primary_key));
        $this->model['document']->delete($this->getAlias(), $primary_key);
        $this->model['opening_stock']->delete($this->getAlias(), $primary_key);
    }

    public function getProductJson() {
        $search = $this->request->post['q'];
        $page = $this->request->post['page'];

        $this->model['product'] = $this->load->model('inventory/product');
        $rows = $this->model['product']->getProductJson($search, $page);

        echo json_encode($rows);
    }

}

class PDF extends TCPDF
{
    public $data = array();

    //Page header
    public function Header()
    {
        // Title
        $this->SetFont('helvetica', 'B', 20);
        $this->Ln(2);
        $this->Cell(0, 10, $this->data['company_name'], 0, false, 'C', 0, '', 0, false, 'M', 'M');
        $this->Ln(10);
        $this->Cell(0, 10, $this->data['report_name'], 0, false, 'C', 0, '', 0, false, 'M', 'M');

        //Logo
        if ($this->data['company_logo'] != '') {
            $image_file = DIR_IMAGE . $this->data['company_logo'];
            $x = 150;
            $y = 5;
            $w = 50;
            $h = '';
            //$this->Rect($x, $y, $w, $h, 'F', array(), array(128,255,128));
            $this->Image($image_file, $x, $y, $w, $h, '', '', 'T', false, 300, '', false, false, 0, false, false, false);
        }


    }
}

?>