<?php

class ControllerGlJournalVoucher extends HController {

    protected $document_type_id = 10;

    protected function getAlias() {
        return 'gl/journal_voucher';
    }

    protected function getPrimaryKey() {
        return 'journal_voucher_id';
    }

    protected function getList() {
        parent::getList();

        $this->data['action_ajax'] = $this->url->link($this->getAlias() . '/getAjaxLists', 'token=' . $this->session->data['token'], 'SSL');
        $this->response->setOutput($this->render());
    }

    public function getAjaxLists() {

        $lang = $this->load->language('gl/bank_payment');
        $this->model[$this->getAlias()] = $this->load->model($this->getAlias());

        $data = array();
        $aColumns = array('action','document_date', 'document_identity' ,'remarks','created_at', 'check_box');

        /*
         * Paging
         */
        $sLimit = "";
        if (isset($_GET['iDisplayStart']) && $_GET['iDisplayLength'] != '-1') {
            $data['criteria']['start'] = $_GET['iDisplayStart'];
            $data['criteria']['limit'] = $_GET['iDisplayLength'];
        }

        /*
         * Ordering
         */
        $sOrder = "";
        if (isset($_GET['iSortCol_0'])) {
            $sOrder = " ORDER BY  ";
            for ($i = 0; $i < intval($_GET['iSortingCols']); $i++) {
                if ($_GET['bSortable_' . intval($_GET['iSortCol_' . $i])] == "true") {
                    $sOrder .= "`" . $aColumns[intval($_GET['iSortCol_' . $i])] . "` " .
                        ($_GET['sSortDir_' . $i] === 'asc' ? 'asc' : 'desc') . ", ";
                }
            }

            $sOrder = substr_replace($sOrder, "", -2);
            if ($sOrder == " ORDER BY") {
                $sOrder = "";
            }
            $data['criteria']['orderby'] = $sOrder;
        }


        /*
         * Filtering
         * NOTE this does not match the built-in DataTables filtering which does it
         * word by word on any field. It's possible to do here, but concerned about efficiency
         * on very large tables, and MySQL's regex functionality is very limited
         */
        $arrWhere = array();
        $arrWhere[] = "`company_id` = '".$this->session->data['company_id']."'";
        $arrWhere[] = "`company_branch_id` = '".$this->session->data['company_branch_id']."'";
        if (isset($_GET['sSearch']) && $_GET['sSearch'] != "") {
            $arrSSearch = array();
            for ($i = 0; $i < count($aColumns); $i++) {
                if (isset($_GET['bSearchable_' . $i]) && $_GET['bSearchable_' . $i] == "true" && $_GET['sSearch'] != '') {
                    $arrSSearch[] = "LOWER(`" . $aColumns[$i] . "`) LIKE '%" . $this->db->escape(strtolower($_GET['sSearch'])) . "%'";
                }
            }
            if(!empty($arrSSearch)) {
                $arrWhere[] = '(' . implode(' OR ', $arrSSearch) . ')';
            }
        }

        /* Individual column filtering */
        for ($i = 0; $i < count($aColumns); $i++) {
            if (isset($_GET['bSearchable_' . $i]) && $_GET['bSearchable_' . $i] == "true" && $_GET['sSearch_' . $i] != '') {
                $arrWhere[] = "LOWER(`" . $aColumns[$i] . "`) LIKE '%" . $this->db->escape(strtolower($_GET['sSearch_' . $i])) . "%' ";
            }
        }

        if (!empty($arrWhere)) {
            //$data['filter']['RAW'] = substr($sWhere, 5, strlen($sWhere) - 5);
            $data['filter']['RAW'] = implode(' AND ', $arrWhere);
        }

        //d($data, true);
        $results = $this->model[$this->getAlias()]->getLists($data);
        $iFilteredTotal = $results['total'];
        $iTotal = $results['table_total'];


        /*
         * Output
         */
        $output = array(
            "sEcho" => intval($_GET['sEcho']),
            "iTotalRecords" => $iTotal,
            "iTotalDisplayRecords" => $iFilteredTotal,
            "aaData" => array()
        );

        foreach ($results['lists'] as $aRow) {
            $row = array();
            $actions = array();

            $actions[] = array(
                'text' => $lang['edit'],
                'href' => $this->url->link($this->getAlias() . '/update', 'token=' . $this->session->data['token'] . '&' . $this->getPrimaryKey() . '=' . $aRow[$this->getPrimaryKey()], 'SSL'),
                'btn_class' => 'btn btn-primary btn-xs',
                'class' => 'fa fa-pencil'
            );

            $actions[] = array(
                'text' => $lang['print'],
                'target' => '_blank',
                'href' => $this->url->link($this->getAlias() . '/printDocument', 'token=' . $this->session->data['token'] . '&' . $this->getPrimaryKey() . '=' . $aRow[$this->getPrimaryKey()], 'SSL'),
                'btn_class' => 'btn btn-info btn-xs',
                'class' => 'fa fa-print'
            );

            if($aRow['is_post']==0) {
                $actions[] = array(
                    'text' => $lang['post'],
                    'href' => $this->url->link($this->getAlias() . '/post', 'token=' . $this->session->data['token'] . '&' . $this->getPrimaryKey() . '=' . $aRow[$this->getPrimaryKey()], 'SSL'),
                    'btn_class' => 'btn btn-info btn-xs',
                    'class' => 'fa fa-thumbs-up'
                );

                $actions[] = array(
                    'text' => $lang['delete'],
                    'href' => 'javascript:void(0);',
                    'click' => "ConfirmDelete('" . $this->url->link($this->getAlias() . '/delete', 'token=' . $this->session->data['token'] . '&id=' . $aRow[$this->getPrimaryKey()], 'SSL') . "')",
                    'btn_class' => 'btn btn-danger btn-xs',
                    'class' => 'fa fa-times'
                );
            }

            $strAction = '';
            foreach ($actions as $action) {
                $strAction .= '<a '.(isset($action['btn_class'])?'class="'.$action['btn_class'].'"':'').' '.(isset($action['target'])?'target="'.$action['target'].'"':'').' href="' . $action['href'] . '" data-toggle="tooltip" title="' . $action['text'] . '" ' . (isset($action['click']) ? 'onClick="' . $action['click'] . '"' : '') . '>';
                if (isset($action['class'])) {
                    $strAction .= '<span class="' . $action['class'] . '"></span>';
                } else {
                    $strAction .= $action['text'];
                }
                $strAction .= '</a>&nbsp;';
            }

            for ($i = 0; $i < count($aColumns); $i++) {
                if ($aColumns[$i] == 'action') {
                    $row[] = $strAction;
                } elseif ($aColumns[$i] == 'document_date') {
                    $row[] = stdDate($aRow['document_date']);
                } elseif ($aColumns[$i] == 'created_at') {
                    $row[] = stdDateTime($aRow['created_at']);
                } elseif ($aColumns[$i] == 'check_box') {
                    if($aRow['is_post']==0) {
                        $row[] = '<input type="checkbox" name="selected[]" value="' . $aRow[$this->getPrimaryKey()] . '" />';
                    } else {
                        $row[] = '';
                    }
                } else {
                    $row[] = $aRow[$aColumns[$i]];
                }

            }
            $output['aaData'][] = $row;
        }

        echo json_encode($output);
    }

    protected function getForm() {
        parent::getForm();
        $this->data['document_identity'] = $this->data['lang']['auto'];
        $this->data['document_date'] = stdDate();
        $this->data['base_currency_id'] = $this->session->data['base_currency_id'];
        $this->data['base_currency'] = $this->session->data['base_currency_name'];
        $this->data['document_currency_id'] = $this->session->data['base_currency_id'];
        $this->data['conversion_rate'] = "1.00";

        $this->model['currency'] = $this->load->model('setup/currency');
        $this->data['currencies'] = $this->model['currency']->getRows(array('company_id' => $this->session->data['company_id']));

        $this->model['coa'] = $this->load->model('gl/coa');
        $this->data['coas'] = $this->model['coa']->getRows(array('company_id' => $this->session->data['company_id']));

//        d($this->data['coas'],true);
        $this->data['partner_types'] = $this->session->data['partner_types'];
        $this->model['partner'] = $this->load->model('common/partner');
        $partners = $this->model['partner']->getRows(array('company_id' => $this->session->data['company_id']));
        //d($partners, true);
        foreach($partners as $partner) {
            $this->data['partners'][$partner['partner_type_id']][$partner['partner_id']] = $partner;
        }

        if (isset($this->request->get['journal_voucher_id']) && ($this->request->server['REQUEST_METHOD'] != 'POST')) {
            $this->data['isEdit'] = 1;
            $this->data['document_type_id'] = $this->document_type_id;
            $this->data['document_id'] = $this->request->get['journal_voucher_id'];

            $result = $this->model[$this->getAlias()]->getRow(array('journal_voucher_id' => $this->request->get['journal_voucher_id']));
            foreach ($result as $field => $value) {
                if ($field == 'document_date') {
                    $this->data[$field] = stdDate($value);
                } else {
                    $this->data[$field] = $value;
                }
            }

            $this->model['document'] = $this->load->model('common/document');
            $this->model['journal_voucher_detail'] = $this->load->model('gl/journal_voucher_detail');
            $filter = array(
                'journal_voucher_id' => $this->request->get['journal_voucher_id']
            );
            $details = $this->model['journal_voucher_detail']->getRows($filter,array('sort_order DESC'));
            foreach($details as $detail) {
                $row_id = $detail['sort_order'];
                if(empty($detail['cheque_date']) || $detail['cheque_date']=='0000-00-00') {
                    $detail['cheque_date'] = '';
                } else {
                    $detail['cheque_date'] = stdDate($detail['cheque_date']);
                }
                if($detail['ref_document_type_id'] && $detail['ref_document_identity']) {
                    $ref_document = $this->model['document']->getRow(array('document_type_id' => $detail['ref_document_type_id'], 'document_identity' => $detail['ref_document_identity']));
                    $detail['href'] = $this->url->link($ref_document['route'].'/update', 'token=' . $this->session->data['token'] . '&' . $ref_document['primary_key_field'] . '=' . $ref_document['primary_key_value'], 'SSL');
                }
                $this->data['journal_voucher_details'][$row_id] = $detail;
            }
        }

        $this->data['href_get_document_ledger'] = $this->url->link('common/function/getDocumentLedger', 'token=' . $this->session->data['token'] . '&' . $this->getPrimaryKey() . '=' . $this->request->get[$this->getPrimaryKey()], 'SSL');
        $this->data['action_post'] = $this->url->link($this->getAlias() . '/post', 'token=' . $this->session->data['token'] . '&' . $this->getPrimaryKey() . '=' . $this->request->get[$this->getPrimaryKey()], 'SSL');
        $this->data['action_un_post'] = $this->url->link($this->getAlias() . '/Unpost', 'token=' . $this->session->data['token'] . '&' . $this->getPrimaryKey() . '=' . $this->request->get[$this->getPrimaryKey()], 'SSL');
        $this->data['action_print'] = $this->url->link($this->getAlias() . '/printDocument', 'token=' . $this->session->data['token'] . '&' . $this->getPrimaryKey() . '=' . $this->request->get[$this->getPrimaryKey()], 'SSL');
        $this->data['action_validate_date'] = $this->url->link('common/function/validateDate', 'token=' . $this->session->data['token']);
        // $this->data['action_validate_date'] = $this->url->link('common/home/validateDate', 'token=' . $this->session->data['token']);
        $this->data['strValidation']= "{
            'rules':{
                'document_date': {'required': true, 'remote':  {url: '" . $this->data['action_validate_date'] . "', type: 'post'}},
                'conversion_rate': {'required':true},
                'document_debit' : {'required': true, 'min': 1},
                'document_credit' : {'required': true, 'min': 1, equalTo: '#document_debit'},
            },
          }";

        $this->response->setOutput($this->render());
    }

    protected function insertData($data) {
        $this->model['document_type'] = $this->load->model('common/document_type');
        $this->model['document'] = $this->load->model('common/document');
    //    $this->model['mapping_account'] = $this->load->model('gl/mapping_coa');
        $this->model['journal_voucher_detail'] = $this->load->model('gl/journal_voucher_detail');
        $this->model['ledger'] = $this->load->model('gl/ledger');

        $document = $this->model['document_type']->getNextDocument($this->document_type_id);

        $data['company_id'] = $this->session->data['company_id'];
        $data['company_branch_id'] = $this->session->data['company_branch_id'];
        $data['fiscal_year_id'] = $this->session->data['fiscal_year_id'];
        $data['document_type_id'] = $this->document_type_id;
        $data['document_prefix'] = $document['document_prefix'];
        $data['document_no'] = $document['document_no'];
        $data['document_identity'] = $document['document_identity'];

        $data['document_date'] = MySqlDate($data['document_date']);
        $data['base_debit'] = $data['document_debit'] * $data['conversion_rate'];
        $data['base_credit'] = $data['document_credit'] * $data['conversion_rate'];
        $journal_voucher_id = $this->model[$this->getAlias()]->add($this->getAlias(), $data);
        $data['document_id'] = $journal_voucher_id;
        //d($data, true);

        $insert_document = array(
            'company_id' => $this->session->data['company_id'],
            'company_branch_id' => $this->session->data['company_branch_id'],
            'fiscal_year_id' => $this->session->data['fiscal_year_id'],
            'document_type_id' => $this->document_type_id,
            'document_id' => $data['document_id'],
            'document_identity' => $data['document_identity'],
            'document_date' => $data['document_date'],
            'document_currency_id' => $data['document_currency_id'],
            'document_amount' => $data['document_debit'],
            'conversion_rate' => $data['conversion_rate'],
            'base_currency_id' => $data['base_currency_id'],
            'base_amount' => $data['base_debit'],
        );
        $document_id = $this->model['document']->add($this->getAlias(), $insert_document);

        foreach ($data['journal_voucher_details'] as $sort_order => $detail) {
            $detail['journal_voucher_id'] = $journal_voucher_id;
            $detail['sort_order'] = $sort_order;
            $detail['company_id'] = $this->session->data['company_id'];
            $detail['company_branch_id'] = $this->session->data['company_branch_id'];
            $detail['fiscal_year_id'] = $this->session->data['fiscal_year_id'];
            $detail['document_currency_id'] = $data['document_currency_id'];
            $detail['base_currency_id'] = $data['base_currency_id'];
            $detail['conversion_rate'] = $data['conversion_rate'];
            $detail['base_debit'] = $detail['document_debit'] * $data['conversion_rate'];
            $detail['base_credit'] = $detail['document_credit'] * $data['conversion_rate'];
            if($detail['cheque_date'] != '') {
                $detail['cheque_date'] = MySqlDate($detail['cheque_date']);
            } else {
                unset($detail['cheque_date']);
            }
            $journal_voucher_detail_id =  $this->model['journal_voucher_detail']->add($this->getAlias(), $detail);

            $gl_data[] = array(
                'document_detail_id' => $journal_voucher_detail_id,
                'coa_id' => $detail['coa_id'],
                'document_currency_id' => $data['document_currency_id'],
                'document_credit' => $detail['document_credit'],
                'document_debit' => $detail['document_debit'],
                'base_currency_id' => $data['base_currency_id'],
                'conversion_rate' => $data['conversion_rate'],
                'credit' => $detail['document_credit'] * $data['conversion_rate'],
                'debit' => $detail['document_debit'] * $data['conversion_rate'],
                'partner_type_id' => $detail['partner_type_id'],
                'partner_id' => $detail['partner_id'],
                'ref_document_type_id' => $detail['ref_document_type_id'],
                'ref_document_identity' => $detail['ref_document_identity'],
                'remarks' => $detail['remarks'],
            );
            //d(array($detail, $gl_data), true);
        }

        foreach($gl_data as $sort_order => $ledger) {
            $ledger['company_id'] = $this->session->data['company_id'];
            $ledger['company_branch_id'] = $this->session->data['company_branch_id'];
            $ledger['fiscal_year_id'] = $this->session->data['fiscal_year_id'];
            $ledger['document_type_id'] = $this->document_type_id;
            $ledger['document_id'] = $data['document_id'];
            $ledger['document_identity'] = $data['document_identity'];
            $ledger['document_date'] = $data['document_date'];
            $ledger['manual_ref_no']= $data['manual_ref_no'];

            $ledger_id = $this->model['ledger']->add($this->getAlias(), $ledger);
        }

        return $journal_voucher_id;
    }

    protected function updateData($primary_key, $data) {
        $this->model['document_type'] = $this->load->model('common/document_type');
        $this->model['document'] = $this->load->model('common/document');
      //  $this->model['mapping_account'] = $this->load->model('gl/mapping_coa');
        $this->model['journal_voucher_detail'] = $this->load->model('gl/journal_voucher_detail');
        $this->model['ledger'] = $this->load->model('gl/ledger');

        $this->model['document']->deleteBulk($this->getAlias(), array('document_id' => $primary_key));
        $this->model['journal_voucher_detail']->deleteBulk($this->getAlias(), array('journal_voucher_id' => $primary_key));
        $this->model['ledger']->deleteBulk($this->getAlias(), array('document_id' => $primary_key));

        $data['document_date'] = MySqlDate($data['document_date']);
        $data['base_debit'] = $data['document_debit'] * $data['conversion_rate'];
        $data['base_credit'] = $data['document_credit'] * $data['conversion_rate'];
        $journal_voucher_id = $this->model[$this->getAlias()]->edit($this->getAlias(), $primary_key, $data);
        $data['document_id'] = $journal_voucher_id;

        $insert_document = array(
            'company_id' => $this->session->data['company_id'],
            'company_branch_id' => $this->session->data['company_branch_id'],
            'fiscal_year_id' => $this->session->data['fiscal_year_id'],
            'document_type_id' => $this->document_type_id,
            'document_id' => $data['document_id'],
            'document_identity' => $data['document_identity'],
            'document_date' => $data['document_date'],
            'document_currency_id' => $data['document_currency_id'],
            'document_amount' => $data['document_debit'],
            'conversion_rate' => $data['conversion_rate'],
            'base_currency_id' => $data['base_currency_id'],
            'base_amount' => $data['base_debit'],
        );
        $document_id = $this->model['document']->add($this->getAlias(), $insert_document);

        foreach ($data['journal_voucher_details'] as $sort_order => $detail) {
            $detail['journal_voucher_id'] = $journal_voucher_id;
            $detail['sort_order'] = $sort_order;
            $detail['company_id'] = $this->session->data['company_id'];
            $detail['company_branch_id'] = $this->session->data['company_branch_id'];
            $detail['fiscal_year_id'] = $this->session->data['fiscal_year_id'];
            $detail['document_currency_id'] = $data['document_currency_id'];
            $detail['base_currency_id'] = $data['base_currency_id'];
            $detail['conversion_rate'] = $data['conversion_rate'];
            $detail['base_debit'] = $detail['document_debit'] * $data['conversion_rate'];
            $detail['base_credit'] = $detail['document_credit'] * $data['conversion_rate'];
            if($detail['cheque_date'] != '') {
                $detail['cheque_date'] = MySqlDate($detail['cheque_date']);
            } else {
                unset($detail['cheque_date']);
            }
            $journal_voucher_detail_id =  $this->model['journal_voucher_detail']->add($this->getAlias(), $detail);

            $gl_data[] = array(
                'document_detail_id' => $journal_voucher_detail_id,
                'coa_id' => $detail['coa_id'],
                'document_currency_id' => $data['document_currency_id'],
                'document_credit' => $detail['document_credit'],
                'document_debit' => $detail['document_debit'],
                'base_currency_id' => $data['base_currency_id'],
                'conversion_rate' => $data['conversion_rate'],
                'credit' => $detail['document_credit'] * $data['conversion_rate'],
                'debit' => $detail['document_debit'] * $data['conversion_rate'],
                'partner_type_id' => $detail['partner_type_id'],
                'partner_id' => $detail['partner_id'],
                'ref_document_type_id' => $detail['ref_document_type_id'],
                'ref_document_identity' => $detail['ref_document_identity'],
                'remarks' => $detail['remarks'],
            );
            //d(array($detail, $gl_data), true);
        }

        foreach($gl_data as $sort_order => $ledger) {
            $ledger['company_id'] = $this->session->data['company_id'];
            $ledger['company_branch_id'] = $this->session->data['company_branch_id'];
            $ledger['fiscal_year_id'] = $this->session->data['fiscal_year_id'];
            $ledger['document_type_id'] = $this->document_type_id;
            $ledger['document_id'] = $data['document_id'];
            $ledger['document_identity'] = $data['document_identity'];
            $ledger['document_date'] = $data['document_date'];
            $ledger['manual_ref_no']= $data['manual_ref_no'];

            $ledger_id = $this->model['ledger']->add($this->getAlias(), $ledger);
        }
        return $journal_voucher_id;
    }

    protected function deleteData($primary_key) {
        $this->model['document'] = $this->load->model('common/document');
        $this->model['journal_voucher_detail'] = $this->load->model('gl/journal_voucher_detail');
        $this->model['ledger'] = $this->load->model('gl/ledger');

        $this->model['ledger']->deleteBulk($this->getAlias(), array('document_id' => $primary_key));
        $this->model['journal_voucher_detail']->deleteBulk($this->getAlias(), array('journal_voucher_id' => $primary_key));
        $this->model['document']->delete($this->getAlias(), $primary_key);
        $this->model[$this->getAlias()]->delete($this->getAlias(), $primary_key);

    }

    public function Unpost() {

        $lang = $this->load->language($this->getAlias());
        $data = array(
            'is_post' => 0,
            'post_date' => date('Y-m-d H:i:s'),
            'post_by_id' => $this->session->data['user_id']
        );
        $this->model[$this->getAlias()] = $this->load->model($this->getAlias());
        $this->model[$this->getAlias()]->edit($this->getAlias(),$this->request->get[$this->getPrimaryKey()],$data);

        $this->model['document'] = $this->load->model('common/document');
        $this->model['document']->edit($this->getAlias(),$this->request->get[$this->getPrimaryKey()],$data);

        $this->redirect($this->url->link($this->getAlias(), 'token=' . $this->session->data['token'] . '&' . $this->getPrimaryKey() . '=' . $this->request->get[$this->getPrimaryKey()], 'SSL'));
    }


    public function printDocument() {

        ini_set('max_execution_time',0);
        ini_set('memory_limit',-1);

        $lang = $this->load->language($this->getAlias());
        $JournalVoucherId = $this->request->get['journal_voucher_id'];
        $post = $this->request->post;
        $session = $this->session->data;

        $this->model['company'] = $this->load->model('setup/company');
        $this->model['company_branch'] = $this->load->model('setup/company_branch');
        $this->model['journal_voucher'] = $this->load->model('gl/journal_voucher');
        $this->model['journal_voucher_detail'] = $this->load->model('gl/journal_voucher_detail');

        $this->model['coa'] = $this->load->model('gl/coa');


        $company = $this->model['company']->getRow(array('company_id' => $this->session->data['company_id']));
        $branch = $this->model['company_branch']->getRow(array('company_branch_id' => $session['company_branch_id']));
        $JournalVoucher = $this->model['journal_voucher']->getRow(array('journal_voucher_id' => $JournalVoucherId));
        $TransactionAccount = $this->model['coa']->getRow(array('coa_id' => $JournalVoucher['transaction_account_id']));


        $JournalVoucherDetails = $this->model['journal_voucher_detail']->getRows(array('journal_voucher_id' => $JournalVoucherId));
//        d($JournalVoucherDetails,true);


        $this->model['ledger'] = $this->load->model('gl/ledger');
        $LedgerDetails = $this->model['ledger']->getTransactionLedger(10,$JournalVoucherId);



        $pdf = new PDF('P', PDF_UNIT, 'A4', true, 'UTF-8', false);

        // set document information
        $pdf->SetCreator(PDF_CREATOR);
        $pdf->SetAuthor('Abdul Samad Khan');
        $pdf->SetTitle('Journal Voucher');
        $pdf->SetSubject('Journal Voucher');

        //Set Header
        $pdf->data = array(
            'company_name' => $session['company_name'],
            'address' => $branch['address'],
            'ntn' => $branch['ntn'],
            'strn' => $branch['strn'],
            'email_address' => $branch['email_address'],
            'company_phone' => $branch['phone_no'],
            'report_name' => 'Journal Voucher',
            'company_logo' => $session['company_image']
        );

        // set margins
        $pdf->SetMargins(15, 30, 5);
        $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
        $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);

        // set auto page breaks
        $pdf->SetAutoPageBreak(TRUE, 40);

        // add a page
        $pdf->AddPage();

        $pdf->SetFont('times', 'B', 12);
        $pdf->SetFillColor(255, 255, 255);
        $pdf->SetTextColor(0, 0, 0);
        $pdf->Cell(190, 7, 'JOURNAL VOUCHER', 'T,B', false, 'C', 1, '', 1);
        $pdf->ln(10);

        $pdf->SetFont('times', 'B', 8);
        $pdf->Cell(18, 6, 'Voucher No: ', 0, false, 'R', 0, '', 0, false, 'M', 'M');

        $pdf->SetFont('times', '', 8);
        $pdf->Cell(40, 6, $JournalVoucher['document_identity'], 0, false, 'L', 0, '', 0, false, 'M', 'M');

        $pdf->SetFont('times', 'B', 8);
        $pdf->Cell(80, 6, 'Voucher Date: ', 0, false, 'R', 0, '', 0, false, 'M', 'M');

        $pdf->SetFont('times', '', 8);
        $pdf->Cell(20, 6, stdDate($JournalVoucher['document_date']), 0, false, 'L', 0, '', 0, false, 'M', 'M');

        $pdf->ln(6);

        $pdf->SetFont('times', 'B', 8);

        $pdf->Cell(18, 6, 'Remarks : ', 0, false, 'L', 0, '', 0, false, 'M', 'M');
        $pdf->SetFont('times','', 8);
        $pdf->SetFillColor(255,255,255);
        $remarks = html_entity_decode($JournalVoucher['remarks']);
        $arrRemarks = splitString($remarks, 115);
        if(count($arrRemarks) == 1) {
            $pdf->Cell(160, 6, $arrRemarks[0], 0, false, 'L', 0, '', 0, false, 'M', 'M');
            $pdf->ln(4);
        } else {
            foreach($arrRemarks as $index => $remarks) {
                if($index==0) {
                    $pdf->Cell(160, 6, $remarks, 0, false, 'L', 0, '', 0, false, 'M', 'M');
                    $pdf->ln(4);
                } else {
                    $pdf->Cell(18, 6, '', 0, false, 'L', 0, '', 0, false, 'M', 'M');
                    $pdf->Cell(160, 6, $remarks, 0, false, 'L', 0, '', 0, false, 'M', 'M');
                    $pdf->ln(4);
                }
            }
        }
        $pdf->ln(3);

        $pdf->SetFont('times', 'B', 8);
        $pdf->SetFillColor(255, 255, 255);
        $pdf->SetTextColor(0, 0, 0);
        $pdf->Cell(25, 7, 'Code.', 'T,B', false, 'C', 1, '', 1);
        $pdf->Cell(105, 7, 'Accounts Description', 'T,B', false, 'L', 1, '', 1);
        $pdf->Cell(30, 7, 'Debit', 'T,B', false, 'C', 1, '', 1);
        $pdf->Cell(30, 7, 'Credit', 'T,B', false, 'C', 1, '', 1);
        $pdf->ln(7);
        $pdf->SetFont('times', '', 8);
        $pdf->SetFillColor(255, 255, 255);
        $pdf->SetTextColor(0, 0, 0);
        $total_debit = 0;
        $total_credit = 0;

        foreach($LedgerDetails as $LedgerDetail) {
            $total_debit += $LedgerDetail['debit'];
            $total_credit += $LedgerDetail['credit'];
            $remarks = html_entity_decode($LedgerDetail['remarks']);

            $pdf->Cell(25, 6, $LedgerDetail['account_code'], 0, false, 'L', 0, '', 1,false, 'T', 'T');
            $pdf->Cell(105, 6, html_entity_decode($LedgerDetail['display_name']), 0, false, 'L', 0, '', 1,false, 'T', 'T');
            $pdf->Cell(30, 6, number_format($LedgerDetail['debit'],2), 0, false, 'R', 0, '', 1,false, 'T', 'T');
            $pdf->Cell(30, 6, number_format($LedgerDetail['credit'],2), 0, false, 'R', 0, '', 1,false, 'T', 'T');
            $pdf->ln(4);
            if($remarks) {
                $arrRemarks = splitString($remarks, 70);
                foreach($arrRemarks as $remarks) {
                    $pdf->Cell(25, 4, '', 0, false, 'L', 0, '', 1,false, 'T', 'T');
                    $pdf->Cell(105, 4, $remarks, 0, false, 'L', 0, '', 1,false, 'T', 'T');
                    $pdf->Cell(30, 4, '', 0, false, 'R', 0, '', 1,false, 'T', 'T');
                    $pdf->Cell(30, 4, '', 0, false, 'R', 0, '', 1,false, 'T', 'T');
                    $pdf->ln(4);
                }
            }
            $pdf->Ln(2);
        }
        $pdf->Ln(4);

        $pdf->SetFont('times', 'B', 8);
        $pdf->Cell(1, 7, '', 0, false, 'R', 0, '', 0, false, 'M', 'M');
        $pdf->Cell(134, 5, 'Totals', 'T,B', false, 'R', 0, '', 0, false, 'M', 'M');
        $pdf->Cell(25, 5, number_format($total_debit,2), 'T,B', false, 'R', 0, '', 0, false, 'M', 'M');
        $pdf->Cell(30, 5, number_format($total_credit,2), 'T,B', false, 'R', 0, '', 0, false, 'M', 'M');
        $pdf->Ln(7);
        $pdf->SetFont('times', '', 8);
        $pdf->Cell(30, 6, 'Amount in Word: ', 0, false, 'L', 0, '', 1);
        $pdf->SetFont('times', 'B', 8);

        $pdf->Cell(160, 6,'Rupees '.Number2Words(round($total_debit,2)).' Only.', 0, false, 'L', 0, '', 1);

        $pdf->Ln(30);
        $pdf->SetFont('times', 'B', 8);
        //$pdf->Cell(180, 4, '', 'B', false, 'L', 0, '', 0, false, 'M', 'M');
        //$pdf->Ln(10);

        $pdf->Cell(33, 7, 'Prepared By', 'T', false, 'C', 0, '', 0, false, 'M', 'M');
        $pdf->Cell(16, 7, '', 0, false, 'C', 0, '', 0, false, 'M', 'M');
        $pdf->Cell(33, 7, 'Checked By', 'T', false, 'C', 0, '', 0, false, 'M', 'M');
        $pdf->Cell(16, 7, '', 0, false, 'C', 0, '', 0, false, 'M', 'M');
        $pdf->Cell(33, 7, 'Approved By', 'T', false, 'C', 0, '', 0, false, 'M', 'M');
        $pdf->Cell(16, 7, '', 0, false, 'C', 0, '', 0, false, 'M', 'M');
        $pdf->Cell(33, 7, 'Received By', 'T', false, 'C', 0, '', 0, false, 'M', 'M');

        /*$pdf->SetMargins(15, 30, 5);
        $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
        $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
        $pdf->AddPage();

        if(count($JournalVoucherDetails) > 0)
        {
            $pdf->setPage(2);
        }
        $pdf->SetFont('times', '', 7);
        $pdf->SetFillColor(255, 255, 255);
        $pdf->SetTextColor(0, 0, 0);
        $total_amount = 0;
        $total_wht_amount = 0;
        $total_ot_amount = 0;
        $total_net_amount = 0;
        $pdf->ln(13);
        foreach($JournalVoucherDetails as $detail) {
            $pdf->ln(8);
            $pdf->Cell(30, 8, $detail['ref_document_identity'], 0, false, 'L', 0, '', 1);
            $pdf->Cell(25, 8, number_format($detail['amount']), 0, false, 'R', 0, '', 1);
            $pdf->Cell(27, 8, 'Exempted Supplies', 0, false, 'C', 0, '', 1);
            $pdf->Cell(15, 8, number_format($detail['wht_percent']), 0, false, 'R', 0, '', 1);
            $pdf->Cell(25, 8, number_format($detail['wht_amount'],4), 0, false, 'R', 0, '', 1);
            $pdf->Cell(15, 8, number_format($detail['other_tax_percent'],4), 0, false, 'R', 0, '', 1);
            $pdf->Cell(25, 8, number_format($detail['other_tax_amount'],2), 0, false, 'R', 0, '', 1);
            $pdf->Cell(27, 8, number_format($detail['net_amount'],2), 0, false, 'R', 0, '', 1);

            $total_amount += $detail['amount'];
            $total_wht_amount += $detail['wht_amount'];
            $total_ot_amount += $detail['other_tax_amount'];
            $total_net_amount += $detail['net_amount'];
        }
        $pdf->ln(2);


        $pdf->SetFont('times', '', 7);


        $pdf->Ln(10);
        $pdf->Cell(30, 7, '', 0, false, 'R', 0, '', 0, false, 'M', 'M');
        $pdf->Cell(25, 7, number_format($total_debit,2), 'T,B', false, 'R', 0, '', 0, false, 'M', 'M');
        $pdf->Cell(42, 7, '', 0, false, 'R', 0, '', 0, false, 'M', 'M');
        $pdf->Cell(24, 7, number_format($total_wht_amount,2), 'T,B', false, 'R', 0, '', 0, false, 'M', 'M');
        $pdf->Cell(18, 7, '', 0, false, 'R', 0, '', 0, false, 'M', 'M');
        $pdf->Cell(24, 7, number_format($total_ot_amount,2), 'T,B', false, 'R', 0, '', 0, false, 'M', 'M');
        $pdf->Cell(2, 7, '', 0, false, 'R', 0, '', 0, false, 'M', 'M');
        $pdf->Cell(24, 7, number_format($total_net_amount,2), 'T,B', false, 'R', 0, '', 0, false, 'M', 'M');*/

        //Close and output PDF document
        $pdf->Output('Journal Voucher:'.date('YmdHis').'.pdf', 'I');
    }

}

class PDF extends TCPDF {
    public $data = array();

    //Page header
    public function Header() {
        // Logo
//        if($this->data['company_logo'] != '') {
//            $image_file = DIR_IMAGE.$this->data['company_logo'];
//            //$this->Image($file, $x='', $y='', $w=0, $h=0, $type='', $link='', $align='', $resize=false, $dpi=300, $palign='', $ismask=false, $imgmask=false, $border=0, $fitbox=false, $hidden=false, $fitonpage=false);
//            //$this->Image($image_file, 10, 5, 150, '', '', '', 'C', false, 300, '', false, false, 1, false, false, false);
//            $x = 150;
//            $y = 0;
//            $w = 50;
//            $h = '';
//            //$this->Rect($x, $y, $w, $h, 'F', array(), array(128,255,128));
//            $this->Image($image_file, $x, $y, $w, $h, '', '', '', false, 300, '', false, false, 0, 'LM', false, false);
//        }

        $image_file = DIR_IMAGE . "Logo WBA.png";
        $this->Image($image_file, 170, 8, 32, 10, '', '', 'R', false, 300, '', false, false, 1, false, false, false);

//        // Set font
//        $this->SetTextColor(255,255,255);
//        $this->SetFont('helvetica', 'B', 10);
//        $this->Ln(2);
//        // Title
//        $this->Cell(0, 4, $this->data['company_name'], 0, false, 'C', 1, '', 0, false, 'M', 'M');
//        $this->Ln(4);
//        if($this->data['company_address']) {
//            $this->Cell(0, 4, $this->data['company_address'], 0, false, 'C', 0, '', 1, false, 'M', 'M');
//            $this->Ln(4);
//        }
//        if($this->data['company_phone']) {
//            $this->Cell(0, 4, 'Phone: '.$this->data['company_phone'], 0, false, 'C', 1, '', 0, false, 'M', 'M');
//            $this->Ln(4);
//        }
//        $this->SetTextColor(0,0,0);
//        $this->Cell(0, 4, $this->data['report_name'], 0, false, 'C', 0, '', 0, false, 'M', 'M');
        if ($this->page == 1) {
            $this->SetFont('helvetica', 'B', 20);
            $this->Ln(2);
            // Title
            $this->Cell(0, 10, $this->data['company_name'], 0, false, 'L', 0, '', 0, false, 'M', 'M');
            $this->Ln(8);
            $this->SetFont('helvetica', '', 8);
            $this->Cell(0, 8, $this->data['address'], 0, false, 'L', 0, '', 0, false, 'M', 'M');
            $this->Ln(4);


        } else {

            $this->SetFont('helvetica', 'B', 20);
            $this->Ln(2);
            // Title
            $this->Cell(0, 10, $this->data['company_name'], 0, false, 'C', 0, '', 0, false, 'M', 'M');
            $this->Ln(10);

            $this->SetFont('helvetica', '', 16);
            $this->Cell(0, 8, $this->data['report_name'], 0, false, 'C', 0, '', 0, false, 'M', 'M');
            $this->Ln(10);

            $this->SetFont('times', 'B', 10);
            $this->SetFillColor(215, 215, 215);
            $this->SetTextColor(0, 0, 0);
            $this->Cell(190, 6, 'Voucher Detail', 0, false, 'C', 1, '', 1);

            $this->ln(12);
            $this->SetFont('times', 'B', 9);
            $this->Cell(17, 6, 'Supplier: ', 0, false, 'L', 0, '', 0, false, 'M', 'M');
            // set font
            $this->SetFont('times', '', 9);
            $this->Cell(140, 6, $this->data['partner_name'], 'B', false, 'L', 0, '', 0, false, 'M', 'M');
            // set font

            $this->ln(10);
            $this->SetFont('times', '', 7);
            $this->SetFillColor(255, 255, 255);
//            $this->SetTextColor(0, 0, 0);
            $this->Cell(30, 8, 'PV Number.', 'T,B', false, 'C', 1, '', 1);
            $this->Cell(25, 8, 'Value', 'T,B', false, 'C', 1, '', 1);
            $this->Cell(27, 8, 'Tax Deduction', 'T,B', false, 'C', 1, '', 1);
            $this->Cell(15, 8, 'WHT %', 'T,B', false, 'C', 1, '', 1);
            $this->Cell(25, 8, 'WHT Amount', 'T,B', false, 'C', 1, '', 1);
            $this->Cell(15, 8, 'OT %', 'T,B', false, 'C', 1, '', 1);
            $this->Cell(25, 8, 'OT Amount', 'T,B', false, 'C', 1, '', 1);
            $this->Cell(27, 8, 'Net Amount', 'T,B', false, 'C', 1, '', 1);
        }
    }

    // Page footer
    public function Footer() {
        $this->SetY(-30);
        // Set font
//        $this->SetFont('helvetica', 'B', 7);
        // Page number
        //      $this->Cell(0, 10, 'Page '.$this->getAliasNumPage().'/'.$this->getAliasNbPages(), 0, false, 'C', 0, '', 0, false, 'T', 'M');
//        if ($this->page != 1) {
//        $this->Cell(180, 4, '', 'B', false, 'L', 0, '', 0, false, 'M', 'M');
//        $this->Ln(10);
//        $this->Ln(5);
//        $this->Cell(25, 7, 'Prepared By', 'T', false, 'C', 0, '', 0, false, 'M', 'M');
//        $this->Cell(10, 7, '', 0, false, 'C', 0, '', 0, false, 'M', 'M');
//        $this->Cell(25, 7, 'Checked By', 'T', false, 'C', 0, '', 0, false, 'M', 'M');
//        $this->Cell(10, 7, '', 0, false, 'C', 0, '', 0, false, 'M', 'M');
//        $this->Cell(25, 7, 'Approved By', 'T', false, 'C', 0, '', 0, false, 'M', 'M');
//        $this->Cell(10, 7, '', 0, false, 'C', 0, '', 0, false, 'M', 'M');
//        $this->Cell(40, 7, 'Vice President Ind.Division', 'T', false, 'C', 0, '', 0, false, 'M', 'M');
//        }
//        $this->Ln(7);
//        $this->SetFont('helvetica', 'B', 8);
//        $this->Cell(0, 5, 'Page '.$this->getAliasNumPage().'/'.$this->getAliasNbPages(), 0, false, 'C', 0, '', 0, false, 'T', 'M');
    }
}

?>