<?php

class ControllerCommonHome extends Controller {

    protected function getAlias() {
        return 'common/home';
    }

    public function index() {
        $this->data['lang'] = $this->load->language('common/home');

        $this->document->setTitle($this->language->get('heading_title'));
        $this->data['heading_title'] = $this->language->get('heading_title');
        if (isset($this->request->server['HTTPS']) && (($this->request->server['HTTPS'] == 'on') || ($this->request->server['HTTPS'] == '1'))) {
            $this->data['base'] = HTTPS_BASE;
        } else {
            $this->data['base'] = HTTP_BASE;
        }

        if (isset($this->session->data['error'])) {
            $this->data['error_warning'] = $this->session->data['error'];

            unset($this->session->data['error']);
        } elseif (isset($this->session->data['warning'])) {
            $this->data['error_warning'] = $this->session->data['warning'];

            unset($this->session->data['warning']);
        } elseif (isset($this->session->data['error_warning'])) {
            $this->data['error_warning'] = $this->session->data['error_warning'];

            unset($this->session->data['error_warning']);
        } else {
            $this->data['error_warning'] = '';
        }

        $this->data['breadcrumbs'] = array();

        $this->data['breadcrumbs'][] = array(
            'text' => $this->data['lang']['dashboard'],
            'href' => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
            'class' => 'fa fa-dashboard',
            'separator' => false
        );

        $this->data['token'] = $this->session->data['token'];
        $company_id = $this->session->data['company_id'];
        $company_branch_id = $this->session->data['company_branch_id'];
        $fiscal_year_id = $this->session->data['fiscal_year_id'];

        $this->model['ledger'] = $this->load->model('gl/ledger');
        $this->data['total_revenue'] = $this->model['ledger']->getTotalRevenue();
        $this->data['total_expense'] = $this->model['ledger']->getTotalExpense();
        $this->data['total_profit'] = $this->data['total_revenue'] - $this->data['total_expense'];
        $this->data['total_asset'] = $this->model['ledger']->getTotalAsset();
        //$this->data['total_cash'] = $this->model['ledger']->getTotalCash();
        $this->data['total_bank'] = $this->model['ledger']->getTotalBank();
        $this->data['total_liability'] = $this->model['ledger']->getTotalLiability();
        $this->data['total_equity'] = $this->model['ledger']->getTotalEquity();
        $this->data['trial_balance_l1_rows'] = $this->model['ledger']->getTrialBalanceL1(array('company_id' => $company_id, 'company_branch_id'=> $company_branch_id, 'fiscal_year_id'=> $fiscal_year_id));

        // Total Product Category //
        $this->model['product_category'] = $this->load->model('inventory/product_category');
        $total_product_category = $this->model['product_category']->getTotalProductCategory();
        $this->data['total_product_category'] = $total_product_category['total_product_category'];

        // Total Product //
        $this->model['product'] = $this->load->model('inventory/product');
        $total_product = $this->model['product']->getTotalProduct();
        $this->data['total_products'] = $total_product['total_product'];

        // Total Product Category In Warehouse//
        $this->model['home'] = $this->load->model('common/home');
        $total_product_category_in_warehouse = $this->model['home']->totalProductCategoryInWarehouse();
        $this->data['total_product_category_in_warehouse'] = $total_product_category_in_warehouse;
//        d($total_product_category_in_warehouse, true);

        // Getting Supplier Balance//
        $this->model['home'] = $this->load->model('common/home');
        $get_supplier_balance = $this->model['home']->getSupplierBalance();
        $this->data['get_supplier_balance'] = $get_supplier_balance;
//        d($get_supplier_balance, true);

        // Getting Supplier Balance//
        $this->model['home'] = $this->load->model('common/home');
        $get_customer_balance = $this->model['home']->getCustomerBalance();
        $this->data['get_customer_balance'] = $get_customer_balance;


//        $this->model['company'] = $this->load->model('setup/company');
//        $this->data['companies'] = $this->model['company']->getRows(array('status' => 'Active'));
//
//        $this->data['action_get_customer'] = $this->url->link($this->getAlias() . '/getCustomer', 'token=' . $this->session->data['token'], 'SSL');
//        $this->data['action_get_sales'] = $this->url->link($this->getAlias() . '/getSale', 'token=' . $this->session->data['token'], 'SSL');
//        $this->data['action_load_widget_graphs'] = $this->url->link($this->getAlias() . '/loadWidgetGraphs', 'token=' . $this->session->data['token'], 'SSL');
//        $this->data['action_update_widget_graphs'] = $this->url->link($this->getAlias() . '/updateWidgetGraphs', 'token=' . $this->session->data['token'], 'SSL');

        $this->template = 'common/home.tpl';
        $this->children = array(
            'common/header',
            'common/column_left',
            'common/column_right',
            'common/page_header',
            'common/page_footer',
            'common/footer',
        );

        $this->response->setOutput($this->render());
    }

    public function login() {
        if(isset($this->session->data['user_id']) && $this->session->data['user_id']) {
            $this->model['user'] = $this->load->model('user/user');
            $user = $this->model['user']->getRow(array('user_id' => $this->session->data['user_id']));
            if ($user) {
                $this->model['user_permission'] = $this->load->model('user/user_permission');
                $permissions = $this->model['user_permission']->getRow(array('user_permission_id' => $user['user_permission_id']));
                $data = $user;
                $data['permissions'] = unserialize($permissions['permission']);

                $this->user->set($data);
            } else {
                return $this->forward('common/logout');
            }

        }

        $route = '';

        if (isset($this->request->get['route'])) {
            $part = explode('/', $this->request->get['route']);

            if (isset($part[0])) {
                $route .= $part[0];
            }

            if (isset($part[1])) {
                $route .= '/' . $part[1];
            }
        }

        $ignore = array(
            'common/login',
            'common/preset',
            'common/forgotten',
            'common/filemanager',
            'common/reset'
        );

        //d(array($this->user->getData(), $this->session->data), true);
        if ((!$this->user->isLogged()) && !in_array($route, $ignore)) {
            return $this->forward('common/logout');
        }

        $user_restricted_ip = $this->user->getIP();
        if($user_restricted_ip &&  $user_restricted_ip != $this->request->server['REMOTE_ADDR']) {
            return $this->forward('common/logout');
        }
    }

    public function permission() {
//        $sk = $this->config->get('config_security_key');
//        if (!$sk) {
//            return $this->forward('error/security');
//        } else {
//            $arrSK = unserialize(base64_decode($sk));
//            if ($arrSK['server'] == $this->request->server['HTTP_HOST']) {
//                if ($arrSK['expiry_date'] != "") {
//                    if ($arrSK['expiry_date'] < date('Y-m-d')) {
//                        return $this->forward('error/security');
//                    }
//                }
//            } else {
//                return $this->forward('error/security');
//            }
//        }

        if (isset($this->request->get['route'])) {
            $route = '';

            $part = explode('/', $this->request->get['route']);

            if (isset($part[0])) {
                $route .= $part[0];
            }

            if (isset($part[1])) {
                $route .= '/' . $part[1];
            }

            $ignore = array(
                'common/home',
                'common/login',
                'common/preset',
                'common/logout',
                'common/forgotten',
                'common/reset',
                'common/filemanager',
                'common/function',
                'error/not_found',
                'error/permission',
                'error/error'
            );

            if (!in_array($route, $ignore) && !$this->user->hasPermission('view', $route)) {
                return $this->forward('error/permission');
            }
        }
    }

}

?>